/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.RepeaterAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

public class GenkotsuMeteorAbility
extends RepeaterAbility {
    public static final GenkotsuMeteorAbility INSTANCE = new GenkotsuMeteorAbility();
    private MODE activeMode = MODE.NORMAL;

    public GenkotsuMeteorAbility() {
        super("Genkotsu Meteor", AbilityHelper.getStyleCategory());
        this.setMaxCooldown(6.0);
        this.setMaxRepeaterCount(1, 1);
        this.setDescription("Throws a cannon ball from the user's inventory or multiple cannon balls in Ryuseigun mode\n\n\u00a72SHIFT-USE\u00a7r: Switches between NORMAL and RYUSEIGUN modes");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        if (player.func_225608_bj_()) {
            if (this.activeMode == MODE.NORMAL) {
                this.setMaxCooldown(12.0);
                this.setMaxRepeaterCount(10, 4);
                this.activeMode = MODE.RYUSEIGUN;
            } else {
                this.setMaxCooldown(6.0);
                this.setMaxRepeaterCount(1, 1);
                this.activeMode = MODE.NORMAL;
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Ability mode set to: " + (Object)((Object)this.activeMode), new Object[0]));
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), props), player);
            return false;
        }
        return true;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!player.func_184614_ca().func_77973_b().equals(ModItems.CANNON_BALL)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_CANNONBALLS, new Object[0]));
            this.stopContinuity(player);
            return false;
        }
        player.func_184614_ca().func_190918_g(1);
        CannonBallProjectile proj = new CannonBallProjectile(player.field_70170_p, (LivingEntity)player);
        proj.setDamage(9.0f);
        proj.onBlockImpactEvent = hit -> {
            if (proj.field_70173_aa < 2) {
                return;
            }
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)proj.func_85052_h(), player.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 1.0f);
            explosion.setStaticDamage(5.0f);
            explosion.setDestroyBlocks(false);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
            explosion.doExplosion();
        };
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f, 2.0f);
        return true;
    }

    public static enum MODE {
        NORMAL,
        RYUSEIGUN;

    }
}

