/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.brawler.KingPunchProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.brawler.KingPunchChargeParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class KingPunchAbility
extends ChargeableAbility {
    public static final KingPunchAbility INSTANCE = new KingPunchAbility();
    private static final KingPunchChargeParticleEffect PARTICLES = new KingPunchChargeParticleEffect();
    private boolean cancelled = false;

    public KingPunchAbility() {
        super("King Punch", AbilityHelper.getStyleCategory());
        this.setDescription("A punch of exceptionally concentrated strength, capable of releasing an immense amount of air pressure, but needs a long time to fully charge");
        this.setMaxCooldown(50.0);
        this.setMaxChargeTime(50.0);
        this.setCancelable();
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        this.cancelled = false;
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTimer) {
        if (!AbilityHelper.canUseBrawlerAbilities((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST, new Object[0]));
            this.cancelled = true;
            this.stopCharging(player);
        }
        if (player.field_70172_ad > 0) {
            this.cancelled = true;
            this.stopCharging(player);
        }
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 1));
        if (chargeTimer % 2 == 0) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        if (this.cancelled) {
            return true;
        }
        int charge = this.getMaxChargeTime() - this.getChargeTime();
        if (charge < 300) {
            return false;
        }
        ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
        KingPunchProjectile proj = new KingPunchProjectile(player.field_70170_p, (LivingEntity)player);
        proj.setDamage((float)charge / 12.0f);
        proj.onBlockImpactEvent = pos -> {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)player, player.field_70170_p, proj.func_226277_ct_(), proj.func_226278_cu_(), proj.func_226281_cx_(), 5.0f + (float)charge / 200.0f);
            explosion.setStaticDamage((float)charge / 15.0f);
            explosion.setExplosionSound(false);
            explosion.setDamageOwner(false);
            explosion.setDestroyBlocks(true);
            explosion.setFireAfterExplosion(false);
            explosion.setDamageEntities(false);
            explosion.doExplosion();
        };
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.0f, 1.0f);
        player.func_195063_d(ModEffects.MOVEMENT_BLOCKED);
        int cooldown = (int)Math.round((double)charge / 20.0) + 5;
        this.setMaxCooldown(cooldown);
        return true;
    }
}

