/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg.CoupDeVentProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class CoupDeVentAbility
extends Ability {
    public static final Ability INSTANCE = new CoupDeVentAbility();

    public CoupDeVentAbility() {
        super("Coup de Vent", AbilityHelper.getRacialCategory());
        this.setMaxCooldown(12.0);
        this.setDescription("Launches a powerful blast of compressed air that blows the opponent away");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.getCola() - 30 < 0) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_COLA, new Object[0]));
            return false;
        }
        CoupDeVentProjectile proj = new CoupDeVentProjectile(player.field_70170_p, (LivingEntity)player);
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f, 1.0f);
        props.alterCola(-30);
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
        return true;
    }
}

