/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg.FreshFireProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.RepeaterAbility;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class FreshFireAbility
extends RepeaterAbility {
    public static final Ability INSTANCE = new FreshFireAbility();

    public FreshFireAbility() {
        super("Fresh Fire", AbilityHelper.getRacialCategory());
        this.setMaxCooldown(5.0);
        this.setMaxRepeaterCount(10, 3);
        this.setDescription("The user heats up and breathes fire like a flamethrower at the opponent");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.getCola() - 2 < 0) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_COLA, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean onUseEvent(PlayerEntity player) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        FreshFireProjectile proj = new FreshFireProjectile(player.field_70170_p, (LivingEntity)player);
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.0f, 10.0f);
        props.alterCola(-2);
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
        return true;
    }
}

