/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doctor;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.doctor.MedicBagExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class MedicBagExplosionAbility
extends Ability {
    public static final MedicBagExplosionAbility INSTANCE = new MedicBagExplosionAbility();
    private static final ParticleEffect PARTICLES = new MedicBagExplosionParticleEffect();

    public MedicBagExplosionAbility() {
        super("Medic Bag Explosion", AbilityHelper.getStyleCategory());
        this.setMaxCooldown(50.0);
        this.setDescription("By sacrificing the medic bag's durability the user can fully heal themselves while applying debuffs to nearby enemies");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        boolean hasMedicBag;
        ItemStack medicBag = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        boolean bl = hasMedicBag = medicBag.func_77973_b() == ModArmors.MEDIC_BAG;
        if (!hasMedicBag) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_MEDIC_BAG, new Object[]{this.getName()}));
            return false;
        }
        player.func_70691_i(player.func_110138_aP() / 2.0f);
        List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 10.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        targets.remove(player);
        for (LivingEntity entity : targets) {
            int effect = (int)WyHelper.randomWithRange(0, 6);
            switch (effect) {
                case 0: {
                    entity.func_195064_c(new EffectInstance(Effects.field_76440_q, 200, 1));
                    break;
                }
                case 1: {
                    entity.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 1));
                    break;
                }
                case 2: {
                    entity.func_195064_c(new EffectInstance(Effects.field_76419_f, 200, 1));
                    break;
                }
                case 3: {
                    entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1));
                    break;
                }
                case 4: {
                    entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 1));
                    break;
                }
                case 5: {
                    entity.func_195064_c(new EffectInstance(Effects.field_82731_v, 200, 1));
                    break;
                }
                case 6: {
                    entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 1));
                }
            }
        }
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        int damage = medicBag.func_77952_i() + 100 <= medicBag.func_77958_k() ? 100 : medicBag.func_77958_k() - medicBag.func_77952_i();
        medicBag.func_222118_a(damage, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        if (medicBag.func_77952_i() >= medicBag.func_77958_k()) {
            medicBag.func_190918_g(1);
        }
        return true;
    }
}

