/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.GomuHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoCulverinProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoElephantGunProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoJetPistolProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoPistolProjectile;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.RepeaterAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class GomuGomuNoGatlingAbility
extends RepeaterAbility {
    public static final GomuGomuNoGatlingAbility INSTANCE = new GomuGomuNoGatlingAbility();
    private boolean hasDataSet = false;

    public GomuGomuNoGatlingAbility() {
        super("Gomu Gomu no Gatling", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Rapidly punches enemies using rubber fists");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldownEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        if (GomuHelper.hasGearFourthActive(props)) {
            this.setMaxCooldown(10.0);
            this.setMaxRepeaterCount(8, 5);
            this.setDisplayName("Gomu Gomu no Kong Gatling");
        } else if (GomuHelper.hasGearThirdActive(props)) {
            this.setMaxCooldown(14.0);
            this.setMaxRepeaterCount(5, 5);
            this.setDisplayName("Gomu Gomu no Elephant Gatling");
        } else if (GomuHelper.hasGearSecondActive(props)) {
            this.setMaxCooldown(5.0);
            this.setMaxRepeaterCount(25, 2);
            this.setDisplayName("Gomu Gomu no Jet Gatling");
        } else {
            this.setMaxCooldown(7.0);
            this.setMaxRepeaterCount(20, 3);
            this.setDisplayName("Gomu Gomu no Gatling");
        }
        return true;
    }

    private boolean onUseEvent(PlayerEntity player) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        AbilityProjectileEntity projectile = null;
        float speed = 3.0f;
        float projDmageReduction = 0.6f;
        int projectileSpace = 2;
        if (GomuHelper.hasGearFourthActive(props)) {
            projectile = new GomuGomuNoCulverinProjectile(player.field_70170_p, (LivingEntity)player);
            projectile.setCollisionSize(2.5);
            if (!this.hasDataSet) {
                speed = 2.2f;
                projectileSpace = 6;
                this.hasDataSet = true;
            }
            projDmageReduction = 0.325f;
        } else if (GomuHelper.hasGearThirdActive(props)) {
            projectile = new GomuGomuNoElephantGunProjectile(player.field_70170_p, (LivingEntity)player);
            projectile.setCollisionSize(2.5);
            if (!this.hasDataSet) {
                speed = 2.4f;
                projectileSpace = 9;
                this.hasDataSet = true;
            }
            projDmageReduction = 0.325f;
        } else if (GomuHelper.hasGearSecondActive(props)) {
            projectile = new GomuGomuNoJetPistolProjectile(player.field_70170_p, (LivingEntity)player);
            if (!this.hasDataSet) {
                speed = 3.6f;
                this.hasDataSet = true;
            }
        } else {
            projectile = new GomuGomuNoPistolProjectile(player.field_70170_p, (LivingEntity)player);
            if (!this.hasDataSet) {
                this.hasDataSet = true;
            }
        }
        projectile.setDamage(projectile.getDamage() * (1.0f - projDmageReduction));
        projectile.setChangeHurtTime(true);
        projectile.func_70012_b(player.func_226277_ct_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble(), player.func_226278_cu_() + 0.3 + WyHelper.randomWithRange(0, projectileSpace) + WyHelper.randomDouble(), player.func_226281_cx_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble(), 0.0f, 0.0f);
        player.field_70170_p.func_217376_c((Entity)projectile);
        projectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, speed, 3.0f);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.GOMU_SFX, SoundCategory.PLAYERS, 0.8f, (float)MathHelper.func_151237_a((double)(player.func_70681_au().nextDouble() * 2.0), (double)1.0, (double)1.3f));
        ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
        return true;
    }

    private void duringCooldownEvent(PlayerEntity player, int cooldown) {
        if (cooldown <= 1) {
            this.hasDataSet = false;
        }
    }
}

