/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.VoltVariProjectile;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SAnimeScreamPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.goro.GenericUseLightningEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class VoltVariAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new VoltVariAbility();
    private static final GenericUseLightningEffect PARTICLES = new GenericUseLightningEffect();
    private int power = 0;

    public VoltVariAbility() {
        super("Volt Vari", AbilityHelper.getDevilFruitCategory());
        this.setDescription("The user discharges variable amounts of electricity, in the form of a concentrated ball or a discharge");
        this.setMaxCooldown(10.0);
        this.setMaxChargeTime(5.0);
        this.setCancelable();
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTimer) {
        this.power = chargeTimer;
        double truePower = Math.abs(this.power - this.getMaxChargeTime());
        if (chargeTimer % 5 == 0) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        AbilityHelper.slowEntityFall((LivingEntity)player);
        String oldName = this.getDisplayName();
        switch (Math.toIntExact(Math.round(truePower))) {
            case 1: {
                this.setDisplayName("1 Million Volt Vari");
                break;
            }
            case 5: {
                this.setDisplayName("5 Millon Volt Vari");
                break;
            }
            case 10: {
                this.setDisplayName("10 Million Volt Vari");
                break;
            }
            case 20: {
                this.setDisplayName("20 Million Volt Vari");
                break;
            }
            case 50: {
                this.setDisplayName("50 Million Volt Vari");
                break;
            }
            case 60: {
                this.setDisplayName("60 Million Volt Vari");
                break;
            }
            case 100: {
                this.setDisplayName("100 Million Volt Vari");
            }
        }
        if (((Boolean)CommonConfig.INSTANCE.animeScreaming.get()).booleanValue() && !this.getDisplayName().equals(oldName)) {
            WyNetwork.sendToAllTrackingAndSelf(new SAnimeScreamPacket(player.func_145782_y(), this.getChargedShouts()[0] + "..."), (LivingEntity)player);
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        float truePower = Math.abs(this.power - this.getMaxChargeTime());
        VoltVariProjectile projectile = new VoltVariProjectile(player.field_70170_p, (LivingEntity)player);
        projectile.setSize(truePower);
        player.field_70170_p.func_217376_c((Entity)projectile);
        projectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 4.0f, 1.0f);
        this.setMaxCooldown(truePower / 10.0f);
        this.setDisplayName("Volt Vari");
        return true;
    }
}

