/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import java.awt.Color;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.abilities.IHakiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IPunchOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;

public class BusoshokuHakiHardeningAbility
extends ContinuousAbility
implements IHakiAbility,
IParallelContinuousAbility,
IPunchOverlayAbility {
    public static final BusoshokuHakiHardeningAbility INSTANCE = new BusoshokuHakiHardeningAbility();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay().setTexture(ModResources.BUSOSHOKU_HAKI_ARM).setColor(new Color(255, 255, 255, 191));
    private static final UUID STRENGTH_UUID = UUID.fromString("0457f786-0a5a-4e83-9ea4-f924c259a798");
    private float damage = 0.0f;

    public BusoshokuHakiHardeningAbility() {
        super("Busoshoku Haki: Hardening", AbilityHelper.getHakiCategory());
        this.setDescription("Covers the fist of the user in Armament haki, making their physical attacks more powerful \n\n This allows the user to hit the true body of devil fruit users");
        this.setInPool(AbilityPool.BUSOSHOKU_HAKI);
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        if (!HakiHelper.canUseHaki(player, this)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONE_HAKI_TYPE, new Object[]{this.getName()}));
            return false;
        }
        if (!HakiHelper.canEnableHaki(player)) {
            return false;
        }
        this.damage = BusoshokuHakiHardeningAbility.getPunchDamage(player);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(this.getEntryAttackDamage(this.damage));
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(this.getEntryAttackDamage(this.damage));
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.BUSOSHOKU_HAKI_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    public static float getPunchDamage(PlayerEntity player) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        float dorikiMultiplier = (float)props.getDoriki() / 10000.0f;
        float hakiMultiplier = Math.min((hakiProps.getBusoshokuHardeningHakiExp() - 30.0f) / 70.0f, 1.0f);
        return dorikiMultiplier * 2.0f + hakiMultiplier * 12.0f;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        ItemStack heldItem;
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(player, passiveTimer / 5900);
        if (isOnMaxOveruse) {
            this.stopContinuity(player);
        }
        if (!(heldItem = player.func_184614_ca()).func_190926_b()) {
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(this.getEntryAttackDamage(0.0));
        } else if (player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111127_a(STRENGTH_UUID) == null) {
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(this.getEntryAttackDamage(this.damage));
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(this.getEntryAttackDamage(0.0));
        int cooldown = (int)WyHelper.clamp(Math.round((double)this.continueTime / 30.0), 5L, 60L);
        this.setMaxCooldown(cooldown);
        if (this.continueTime / 20 > 10) {
            HakiHelper.checkForHakiOveruse(player, 100);
        }
        return true;
    }

    private AttributeModifier getEntryAttackDamage(double amount) {
        return new AttributeModifier(STRENGTH_UUID, "Hardening Haki Strength Attack", amount, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    }

    @Override
    public HakiType getType() {
        return HakiType.HARDENING;
    }

    @Override
    public AbilityOverlay getPunchOverlay(LivingEntity player) {
        return OVERLAY;
    }
}

