/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.abilities.IFallDamageBlockingAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class SoraNoMichiAbility
extends Ability
implements IFallDamageBlockingAbility {
    public static final SoraNoMichiAbility INSTANCE = new SoraNoMichiAbility();
    public int airJumps = 0;
    private boolean hasFallDamage = true;

    public SoraNoMichiAbility() {
        super("Sora no Michi", AbilityHelper.getDevilFruitCategory());
        this.setInPool(AbilityPool.GEPPO_LIKE);
        this.setMaxCooldown(1.0);
        this.setDescription("The user attaches the strings to clouds, allowing them to move through the air");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player) || player.func_226278_cu_() > (double)player.field_70170_p.func_72912_H().func_76067_t().getCloudHeight()) {
            return false;
        }
        ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
        if (player.field_70122_E) {
            Vec3d speed = WyHelper.propulsion((LivingEntity)player, 1.1, 1.1);
            player.func_213293_j(speed.field_72450_a, 2.4, speed.field_72449_c);
        } else {
            Vec3d speed = WyHelper.propulsion((LivingEntity)player, 2.5, 2.5);
            player.func_213293_j(speed.field_72450_a, 0.8, speed.field_72449_c);
        }
        AbilityHelper.setAirJumps(player, this.airJumps + 1);
        player.field_70133_I = true;
        this.hasFallDamage = false;
        if (this.airJumps >= 12) {
            this.setMaxCooldown((float)this.airJumps * 2.0f);
            this.startCooldown(player);
            AbilityHelper.setAirJumps(player, 0);
            return true;
        }
        this.setMaxCooldown(1.0);
        return true;
    }

    @Override
    public void resetFallDamage(LivingEntity player) {
        if (this.airJumps > 0) {
            this.setMaxCooldown((float)this.airJumps * 2.0f);
            this.startCooldown((PlayerEntity)player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((PlayerEntity)player, this), player);
            this.checkAbilityPool((PlayerEntity)player, Ability.State.COOLDOWN);
        }
        this.hasFallDamage = true;
        AbilityHelper.setAirJumps((PlayerEntity)player, 0);
    }

    @Override
    public boolean hasFallDamage() {
        return this.hasFallDamage;
    }
}

