/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.magu;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IPunchOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IChangeDamageSourceAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;

public class MagmaCoatingAbility
extends ContinuousAbility
implements IChangeDamageSourceAbility,
IPunchOverlayAbility,
IParallelContinuousAbility {
    private static final AbilityOverlay OVERLAY = new AbilityOverlay().setTexture(ModResources.DOKU_COATING).setColor(new Color(160, 0, 0));
    public static final Ability INSTANCE = new MagmaCoatingAbility();

    public MagmaCoatingAbility() {
        super("Magma Coating", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(30.0);
        this.setMaxCooldown(10.0);
        this.setDescription("The user coats their arm with magma");
        this.duringContinuityEvent = this::duringContinuityEvent;
    }

    private void duringContinuityEvent(PlayerEntity player, int i) {
    }

    @Override
    public float damageToEntityWithSource(PlayerEntity player, LivingEntity target) {
        float strength = Math.min((float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e(), 50.0f);
        float absorption = 0.5f;
        SetOnFireEvent event = new SetOnFireEvent((LivingEntity)player, target, 5);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            target.func_70015_d(5);
        }
        ItemStack gear = player.func_184614_ca();
        if (!player.func_184614_ca().func_190926_b()) {
            absorption /= 2.0f;
            gear.func_222118_a(gear.func_77958_k() / 3 + 1, target, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return 16.0f + strength * absorption;
    }

    @Override
    public DamageSource getSourceToUse(PlayerEntity player) {
        return ModDamageSource.MAGMA.causeEntityDamageFromSource((Entity)player);
    }

    @Override
    public boolean cancelsOriginalDamage() {
        return true;
    }

    @Override
    public boolean isSourceChangeEnabled() {
        return this.isContinuous();
    }

    @Override
    public AbilityOverlay getPunchOverlay(LivingEntity entity) {
        return OVERLAY;
    }
}

