/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.netsu;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IBodyOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.particles.effects.netsu.NetsuEnhancementParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IChangeDamageSourceAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;

public class NetsuEnhancementAbility
extends ContinuousAbility
implements IParallelContinuousAbility,
IChangeDamageSourceAbility,
IBodyOverlayAbility {
    public static final NetsuEnhancementAbility INSTANCE = new NetsuEnhancementAbility();
    private static final NetsuEnhancementParticleEffect PARTICLES = new NetsuEnhancementParticleEffect();
    private static final AttributeModifier MULTIPLIER = new AttributeModifier(UUID.fromString("efa08cbd-57e5-478f-b15c-6295eb1b375e"), "Netsu Multiplier", 0.25, AttributeModifier.Operation.MULTIPLY_BASE).func_111168_a(false);
    private static final AbilityOverlay OVERLAY = new AbilityOverlay().setRenderType(AbilityOverlay.RenderType.ENERGY).setColor(WyHelper.hexToRGB("#962A2AAA"));

    public NetsuEnhancementAbility() {
        super("Netsu Enhancement", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(40.0);
        this.setDescription("Increases the user's attacks and body functions through heat");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onEndContinuityEvent = this::endContinuity;
        this.duringContinuityEvent = this::duringContinuityEvent;
    }

    private boolean endContinuity(PlayerEntity player) {
        player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(MULTIPLIER);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(MULTIPLIER);
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111124_b(MULTIPLIER);
        int cooldown = (int)Math.round((double)this.continueTime / 40.0) + 15;
        this.setMaxCooldown(cooldown);
        return true;
    }

    private void duringContinuityEvent(PlayerEntity player, int timer) {
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(MULTIPLIER);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(MULTIPLIER);
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111121_a(MULTIPLIER);
        return true;
    }

    @Override
    public AbilityOverlay getBodyOverlay() {
        return OVERLAY;
    }

    @Override
    public float damageToEntityWithSource(PlayerEntity player, LivingEntity target) {
        SetOnFireEvent event;
        float strength = Math.min((float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e(), 60.0f);
        float keptDamage = 0.375f * (1.0f - strength / 160.0f);
        if (target.field_70172_ad > 0 && target.field_70172_ad <= 5) {
            target.field_70172_ad = 0;
            target.field_70737_aN = 0;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(event = new SetOnFireEvent((LivingEntity)player, target, 5)))) {
            target.func_70015_d(5);
        }
        return 8.0f + Math.min(strength * keptDamage, 15.0f);
    }

    @Override
    public DamageSource getSourceToUse(PlayerEntity player) {
        return new ModDamageSource("onFire", false, true, false).causeEntityDamageFromSource((Entity)player);
    }

    @Override
    public boolean cancelsOriginalDamage() {
        return false;
    }

    @Override
    public boolean isSourceChangeEnabled() {
        return this.isContinuous();
    }
}

