/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.nikyu;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class PuniAbility
extends ContinuousAbility {
    public static final PuniAbility INSTANCE = new PuniAbility();

    public PuniAbility() {
        super("Puni", AbilityHelper.getDevilFruitCategory());
        this.setDescription("The user takes a defensive posture that uses their paw pads to repel and counter enemy attacks");
        this.setThreshold(1.0);
        this.setMaxCooldown(4.0);
        this.onStartContinuityEvent = this::onStartContiunityEvent;
        this.duringContinuityEvent = this::duringContinuity;
    }

    private boolean onStartContiunityEvent(PlayerEntity player) {
        return player.func_184614_ca().func_190926_b();
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        if (!player.func_184614_ca().func_190926_b()) {
            this.stopContinuity(player);
        }
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 1, false, false));
        int range = 3;
        double boxSize = 0.85;
        for (int i = 0; i < range * 2; ++i) {
            double distance = (double)i / 2.0;
            Vec3d lookVec = player.func_70040_Z();
            Vec3d pos = new Vec3d(player.func_226277_ct_() + lookVec.field_72450_a * distance, player.func_226278_cu_() + (double)player.func_70047_e() + lookVec.field_72448_b * distance, player.func_226281_cx_() + lookVec.field_72449_c * distance);
            List list = player.field_70170_p.func_175674_a((Entity)player, new AxisAlignedBB(pos.field_72450_a - boxSize, pos.field_72448_b - boxSize, pos.field_72449_c - boxSize, pos.field_72450_a + boxSize, pos.field_72448_b + boxSize * 2.0, pos.field_72449_c + boxSize), entity -> entity != player);
            for (Entity e : list) {
                if (e instanceof LivingEntity) {
                    e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 15.0f);
                    Vec3d speed = WyHelper.propulsion((LivingEntity)player, 6.0, 6.0);
                    e.func_213293_j(speed.field_72450_a, 1.5, speed.field_72449_c);
                    e.field_70133_I = true;
                    continue;
                }
                if (!(e instanceof ThrowableEntity)) continue;
                e.func_213293_j(-e.func_213322_ci().field_72450_a * 3.0, e.func_213322_ci().field_72448_b + 0.5, -e.func_213322_ci().field_72450_a * 3.0);
            }
        }
    }
}

