/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pero;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IBodyOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class CandyArmorAbility
extends ContinuousAbility
implements IBodyOverlayAbility {
    public static final CandyArmorAbility INSTANCE = new CandyArmorAbility();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay().setTexture(ModResources.CANDY_ARMOR).setColor(WyHelper.hexToRGB("#FFFFFF99"));

    public CandyArmorAbility() {
        super("Candy Armor", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(15.0);
        this.setDescription("Coat yourself with a hard candy armor, which boosts defense, but reduces mobility");
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        player.func_195064_c(new EffectInstance(Effects.field_76429_m, 20, 2, false, false));
        player.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 2, false, false));
        player.func_195064_c(new EffectInstance(Effects.field_76419_f, 20, 1, false, false));
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        int cooldown = (int)Math.round((double)this.continueTime / 12.0) + 2;
        this.setMaxCooldown(cooldown);
        player.func_195063_d(Effects.field_76429_m);
        player.func_195063_d(Effects.field_76421_d);
        player.func_195063_d(Effects.field_76419_f);
        return true;
    }

    @Override
    public AbilityOverlay getBodyOverlay() {
        return OVERLAY;
    }
}

