/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import xyz.pixelatedw.mineminenomi.abilities.suna.DesertGirasoleAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.OreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.suna.GroundDeathParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class GroundDeathAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new GroundDeathAbility();
    private static final ParticleEffect PARTICLES = new GroundDeathParticleEffect();
    private final BlockPlacingHelper blockPlacingHelper = new BlockPlacingHelper();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(AirBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE, CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, OreBlockProtectionRule.INSTANCE);
    private List<LivingEntity> targets = new ArrayList<LivingEntity>();

    public GroundDeathAbility() {
        super("Ground Death", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(10.0);
        this.setMaxChargeTime(5.0);
        this.setCancelable();
        this.setDescription("Dries out the surroundings and suffocates all nearby opponents in sand");
        this.onStartChargingEvent = this::onStartCharging;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        this.targets.clear();
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int i) {
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 2, 1, false, false));
        HashSet<BlockPos> blockList = this.blockPlacingHelper.getBlockList();
        int finished = blockList.size() / 100;
        Iterator<BlockPos> iterator = blockList.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = iterator.next();
            if (finished-- < 0) break;
            BlockPos pos = new BlockPos((Vec3i)blockPos);
            boolean isWater = player.field_70170_p.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).func_185904_a() == Material.field_151586_h;
            AbilityHelper.placeBlockIfAllowed(player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), isWater ? Blocks.field_150350_a : Blocks.field_150354_m, GRIEF_RULE);
            for (LivingEntity target : WyHelper.getEntitiesNear(pos, player.field_70170_p, 1.5, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class)) {
                if (this.targets.contains(target) || target.func_110124_au() == player.func_110124_au()) continue;
                this.targets.add(target);
                AbilityHelper.createFilledCube(target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 1, (int)Math.round(target.func_226280_cw_() - target.func_226278_cu_()), 1, Blocks.field_150354_m, GRIEF_RULE);
                target.func_195064_c(new EffectInstance(Effects.field_76419_f, 200, 3, false, false));
                PARTICLES.spawn(player.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            iterator.remove();
        }
    }

    private boolean onStartCharging(PlayerEntity player) {
        DesertGirasoleAbility ability = (DesertGirasoleAbility)AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(DesertGirasoleAbility.INSTANCE);
        if (ability != null && ability.isContinuous()) {
            return false;
        }
        if (!player.field_70122_E) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_GROUND, new Object[]{this.getName()}));
            return false;
        }
        this.blockPlacingHelper.clearList();
        int range = DesertGirasoleAbility.isFruitBoosted(player) ? 40 : 20;
        for (int i = -range; i < range; ++i) {
            for (int j = -12; j < 8; ++j) {
                for (int k = -range; k < range; ++k) {
                    double posZ;
                    double posY;
                    double posX = player.func_226277_ct_() + (double)i + ((double)i < -WyHelper.randomWithRange((int)((float)range * 0.5f), (int)((float)range * 0.75f)) || (double)i > WyHelper.randomWithRange((int)((float)range * 0.5f), (int)((float)range * 0.75f)) ? WyHelper.randomWithRange(-5, 5) : 0.0);
                    if (player.field_70170_p.func_180495_p(new BlockPos(posX, posY = player.func_226278_cu_() + (double)j, posZ = player.func_226281_cx_() + (double)k + ((double)k < -WyHelper.randomWithRange((int)((float)range * 0.5f), (int)((float)range * 0.75f)) || (double)k > WyHelper.randomWithRange((int)((float)range * 0.5f), (int)((float)range * 0.75f)) ? WyHelper.randomWithRange(-5, 5) : 0.0))).isAir((IBlockReader)player.field_70170_p, new BlockPos(posX, posY, posZ))) continue;
                    this.blockPlacingHelper.addBlockPos(new BlockPos(posX, posY, posZ), i * i + j * j + k * k);
                }
            }
        }
        return !player.func_70026_G();
    }
}

