/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yami.BlackRoadProjectile;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.yami.DarkMatterChargingParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class BlackRoadAbility
extends ChargeableAbility {
    public static final BlackRoadAbility INSTANCE = new BlackRoadAbility();
    private static final ParticleEffect PARTICLES = new DarkMatterChargingParticleEffect();

    public BlackRoadAbility() {
        super("Black Road", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(20.0);
        this.setMaxChargeTime(6.0);
        this.setCancelable();
        this.setDescription("The user spreads darkness in a forward path");
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::endChargingEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTime) {
        if (chargeTime % 2 == 0) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    private boolean endChargingEvent(PlayerEntity player) {
        float time = (float)this.getChargeTime() / (float)this.getMaxChargeTime();
        float multiplier = 1.0f - time;
        int range = (int)(24.0f * multiplier);
        BlackRoadProjectile proj = new BlackRoadProjectile(player.field_70170_p, (LivingEntity)player);
        proj.setMaxLife(range);
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.1f, 5.0f);
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.MAGU_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }
}

