/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zushi;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class GraviPullAbility
extends ChargeableAbility {
    public static final GraviPullAbility INSTANCE = new GraviPullAbility();

    public GraviPullAbility() {
        super("Gravi Pull", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Pulls all enemies in a radius towards the user");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
        this.setMaxCooldown(17.0);
        this.setMaxChargeTime(3.0);
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        for (double i = 0.0; i < 7.283185307179586; i += 0.09817477042468103) {
            GenericParticleData data = new GenericParticleData(ModParticleTypes.GASU);
            data.setLife(100);
            data.setSize(2.0f);
            double offsetX = Math.cos(i);
            double offsetZ = Math.sin(i);
            data.setMotion(offsetX / 5.0, 0.0, offsetZ / 5.0);
            data.setHasMotionDecay(false);
            WyHelper.spawnParticles(data, (ServerWorld)player.field_70170_p, player.func_226277_ct_() + offsetX, player.func_226278_cu_() + 1.0, player.func_226281_cx_() + offsetZ);
        }
        return true;
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        for (double i = 0.0; i < 7.283185307179586; i += 0.09817477042468103) {
            GenericParticleData data = new GenericParticleData(ModParticleTypes.GASU);
            data.setLife(5);
            data.setSize(2.0f);
            double offsetX = Math.cos(i) * 20.0;
            double offsetZ = Math.sin(i) * 20.0;
            data.setMotion(-offsetX / 10.0, 0.0, -offsetZ / 10.0);
            WyHelper.spawnParticles(data, (ServerWorld)player.field_70170_p, player.func_226277_ct_() + offsetX, player.func_226278_cu_() + 1.0, player.func_226281_cx_() + offsetZ);
        }
        List<Entity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 16.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        list.forEach(e -> {
            double offsetX = player.func_226277_ct_() - e.func_226277_ct_();
            double offsetZ = player.func_226281_cx_() - e.func_226281_cx_();
            e.func_213293_j(offsetX / 2.0, (player.func_226278_cu_() - e.func_226278_cu_()) / 4.0, offsetZ / 2.0);
            e.field_70133_I = true;
        });
        return true;
    }
}

