/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.EntityRayTraceResult;
import xyz.pixelatedw.mineminenomi.api.abilities.TempoAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.artofweather.FailedTempoParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class ArtOfWeatherHelper {
    private static final ParticleEffect FAILED_TEMPO_PARTICLES = new FailedTempoParticleEffect();

    public static void checkForTempo(PlayerEntity player, ParticleEffect chargeParticles) {
        ClimaTactItem climaTact = (ClimaTactItem)player.func_184614_ca().func_77973_b();
        String tempoCombo = climaTact.checkCharge(player.func_184614_ca());
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 1.5);
        if (tempoCombo.length() == 3) {
            List availableTempos = props.getUnlockedAbilities(AbilityHelper.getStyleCategory()).stream().filter(ability -> ability instanceof TempoAbility).collect(Collectors.toList());
            boolean hasTempo = false;
            for (TempoAbility tempo : availableTempos) {
                if (!tempo.canUseTempo(player, null)) continue;
                tempo.use(player);
                climaTact.emptyCharge(player.func_184614_ca());
                hasTempo = true;
                break;
            }
            if (!hasTempo) {
                FAILED_TEMPO_PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
                climaTact.emptyCharge(player.func_184614_ca());
            }
        } else {
            chargeParticles.spawn(player.field_70170_p, trace.func_216347_e().func_82615_a(), player.func_226278_cu_(), trace.func_216347_e().func_82616_c(), 0.0, 0.0, 0.0);
        }
    }
}

