/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.blocks.traps;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;

public abstract class TrapAbilityBlock
extends Block {
    private int damageDealt = 0;
    private double horizontalFallSpeed = 0.05;
    private double verticalFallSpeed = 0.25;
    private EffectInstance potionEffect = null;

    public TrapAbilityBlock(Block.Properties properties) {
        super(properties);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            IDevilFruit props = DevilFruitCapability.get((LivingEntity)entity);
            if (!props.hasDevilFruit(this.getDevilFruit())) {
                entity.func_213295_a(state, new Vec3d(this.getHorizontalFallSpeed(), this.getVerticalFallSpeed(), this.getHorizontalFallSpeed()));
            }
        } else if (entity instanceof BoatEntity) {
            entity.func_70106_y();
        } else {
            entity.func_213295_a(state, new Vec3d(this.getVerticalFallSpeed(), this.getHorizontalFallSpeed(), this.getVerticalFallSpeed()));
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        PlayerEntity player;
        Entity entity = context.getEntity();
        if (entity instanceof PlayerEntity && DevilFruitCapability.get((LivingEntity)(player = (PlayerEntity)entity)).hasDevilFruit(this.getDevilFruit())) {
            return state.func_196954_c(worldIn, pos);
        }
        return super.func_220071_b(state, worldIn, pos, context);
    }

    public int getDamageDealt() {
        return this.damageDealt;
    }

    public void setDamageDealt(int damageDealt) {
        this.damageDealt = damageDealt;
    }

    public double getVerticalFallSpeed() {
        return this.verticalFallSpeed;
    }

    public void setVerticalFallSpeed(double verticalFallSpeed) {
        this.verticalFallSpeed = verticalFallSpeed;
    }

    public EffectInstance getPotionEffect() {
        return this.potionEffect;
    }

    public void setPotionEffect(EffectInstance potionEffect) {
        this.potionEffect = potionEffect;
    }

    public abstract AkumaNoMiItem getDevilFruit();

    public boolean func_181623_g() {
        return false;
    }

    public double getHorizontalFallSpeed() {
        return this.horizontalFallSpeed;
    }

    public void setHorizontalFallSpeed(double horizontalFallSpeed) {
        this.horizontalFallSpeed = horizontalFallSpeed;
    }

    public static boolean isEntityInsideOpaqueBlock(LivingEntity e, int offSet) {
        try (BlockPos.PooledMutable blockpos$pooledmutableblockpos = BlockPos.PooledMutable.func_185346_s();){
            for (int i = 0; i < 8; ++i) {
                int j = MathHelper.func_76128_c((double)(e.func_226278_cu_() - (double)offSet + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)e.func_70047_e()));
                int k = MathHelper.func_76128_c((double)(e.func_226277_ct_() + (double)(((float)((i >> 1) % 2) - 0.5f) * e.func_213302_cg() * 0.8f)));
                int l = MathHelper.func_76128_c((double)(e.func_226281_cx_() + (double)(((float)((i >> 2) % 2) - 0.5f) * e.func_213311_cf() * 0.8f)));
                if (blockpos$pooledmutableblockpos.func_177958_n() == k && blockpos$pooledmutableblockpos.func_177956_o() == j && blockpos$pooledmutableblockpos.func_177952_p() == l) continue;
                blockpos$pooledmutableblockpos.func_181079_c(k, j, l);
                if (!(e.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_177230_c() instanceof TrapAbilityBlock)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

