/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;

public class CheckFruitsCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"check_fruits").requires(source -> source.func_197034_c(3));
        builder.executes(context -> CheckFruitsCommand.checkFruitsInWorld((CommandContext<CommandSource>)context));
        dispatcher.register(builder);
    }

    private static int checkFruitsInWorld(CommandContext<CommandSource> context) {
        StringBuilder fruitsString;
        String playerName;
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("This command can only be used when the One Fruit per World config option is enabled."));
            return 0;
        }
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ExtendedWorldData worldData = ExtendedWorldData.get((World)world);
        StringBuilder builder = new StringBuilder();
        builder.append("===============================================\n");
        builder.append("\u00a7l\u00a76Devil Fruits in World\n");
        builder.append(worldData.getDevilFruitsInWorld().size() + " ");
        for (String fruit : worldData.getDevilFruitsInWorld()) {
            builder.append(fruit + " ");
        }
        builder.append("\n");
        builder.append("\n");
        builder.append("\u00a7l\u00a76Devil Fruits in Player's Inventories\n");
        HashMap<UUID, List<String>> inventories = worldData.getFruitsInInventory();
        for (Map.Entry<UUID, List<String>> entry : inventories.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            playerName = world.func_73046_m().func_152358_ax().func_152652_a(entry.getKey()).getName();
            builder.append(playerName + " - ");
            fruitsString = new StringBuilder();
            for (String fruitName : entry.getValue()) {
                fruitsString.append(fruitName + " ");
            }
            builder.append(fruitsString.toString() + "\n");
        }
        builder.append("\n");
        builder.append("\u00a7l\u00a76Devil Fruits Eaten by a Player\n");
        for (Map.Entry<UUID, Object> entry : worldData.getAteFruits().entrySet()) {
            playerName = world.func_73046_m().func_152358_ax().func_152652_a(entry.getKey()).getName();
            builder.append(playerName + " : " + (String)entry.getValue() + "\n");
        }
        builder.append("\n");
        builder.append("\u00a7l\u00a76Logged Out Devil Fruits\n");
        for (Map.Entry<UUID, Object> entry : worldData.getLoggedOutDevilFruits().entrySet()) {
            playerName = world.func_73046_m().func_152358_ax().func_152652_a(entry.getKey()).getName();
            fruitsString = new StringBuilder();
            for (String fruitName : (List)((Pair)entry.getValue()).getValue()) {
                fruitsString.append(fruitName + " ");
            }
            builder.append(((Date)((Pair)entry.getValue()).getKey()).toString() + " - " + playerName + " : " + fruitsString.toString() + "\n");
        }
        builder.append("===============================================");
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), false);
        return 1;
    }
}

