/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.challenges;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;

public class ChallengesDataBase
implements IChallengesData {
    private List<Challenge> challenges = new ArrayList<Challenge>();

    @Override
    public boolean addChallenge(Challenge challenge) {
        Challenge ogChallenge = this.getChallenge(challenge);
        if (ogChallenge == null) {
            this.challenges.add(challenge);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeChallenge(Challenge challenge) {
        Challenge ogChallenge = this.getChallenge(challenge);
        if (ogChallenge != null) {
            this.challenges.remove((Object)ogChallenge);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChallenge(Challenge challenge) {
        this.challenges.removeIf(chl -> chl == null);
        return this.challenges.parallelStream().anyMatch(chl -> chl.equals((Object)challenge));
    }

    @Override
    public <T extends Challenge> T getChallenge(T challenge) {
        this.challenges.removeIf(qst -> qst == null);
        return (T)((Object)((Challenge)this.challenges.parallelStream().filter(chl -> chl.equals((Object)challenge)).findFirst().orElse(null)));
    }

    @Override
    public <T extends Challenge> T getChallenge(String challengeKey) {
        this.challenges.removeIf(qst -> qst == null);
        return (T)((Object)((Challenge)this.challenges.parallelStream().filter(chl -> chl.getId().equalsIgnoreCase(challengeKey)).findFirst().orElse(null)));
    }

    @Override
    public List<Challenge> getChallenges() {
        this.challenges.removeIf(chl -> chl == null);
        return this.challenges.parallelStream().collect(Collectors.toList());
    }

    @Override
    public Map<String, List<Challenge>> getGroupedChallenges() {
        return this.challenges.stream().collect(Collectors.groupingBy(Challenge::getCategory));
    }

    @Override
    public void clearChallenges() {
        this.challenges.clear();
    }

    @Override
    public int countChallenges() {
        this.challenges.removeIf(chl -> chl == null);
        return this.challenges.size();
    }

    @Override
    public Optional<Challenge> getCurrentChallenge(PlayerEntity player, String category) {
        return this.getGroupedChallenges().get(category).stream().filter(ch -> !ch.isLocked(player) && !ch.isComplete()).findFirst();
    }
}

