/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.entities.mobs.IDynamicRenderer;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEntities;

public class DenDenMushiEntity
extends AnimalEntity
implements IDynamicRenderer {
    private static final DataParameter<Integer> TEXTURE_ID = EntityDataManager.func_187226_a(DenDenMushiEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private String[] textures = new String[]{"den_den_mushi1", "den_den_mushi2", "den_den_mushi3"};

    public DenDenMushiEntity(World worldIn) {
        super(ModEntities.DEN_DEN_MUSHI, worldIn);
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 0.75));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TEXTURE_ID, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.12);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        if (this.textures != null && this.textures.length > 0) {
            this.setTexture(this.field_70146_Z.nextInt(this.textures.length));
        }
        return spawnData;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151042_j) {
            ItemStack denStack = new ItemStack((IItemProvider)ModBlocks.DEN_DEN_MUSHI);
            denStack.func_196082_o().func_74768_a("type", this.getTextureId());
            player.field_71071_by.func_70441_a(denStack);
            stack.func_190918_g(1);
            this.func_70106_y();
            return true;
        }
        return false;
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("Texture", this.getTextureId());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setTexture(nbt.func_74762_e("Texture"));
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    public int getTextureId() {
        return (Integer)this.func_184212_Q().func_187225_a(TEXTURE_ID);
    }

    protected void setTexture(int texture) {
        this.func_184212_Q().func_187227_b(TEXTURE_ID, (Object)texture);
    }

    @Override
    public String getMobTexture() {
        return this.textures[this.getTextureId()];
    }

    @Override
    public String getDefaultTexture() {
        return this.textures[0];
    }
}

