/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.FollowBoatGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.YagaraBullEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.BreakBoatGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;

public class FightingFishEntity
extends WaterMobEntity {
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(FightingFishEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final EntityPredicate TARGET_PREDICATE = new EntityPredicate().func_221013_a(20.0).func_221011_b().func_221008_a().func_221014_c();

    public FightingFishEntity(World world) {
        super(ModEntities.FIGHTING_FISH, world);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 10);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.8f, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 12.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowBoatGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new BreakBoatGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, YagaraBullEntity.class, 10, true, true, living -> !(living instanceof FightingFishEntity)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(55.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)1.2f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Math.ceil(7.0f * this.getSize()));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Math.ceil(60.0 * (double)this.getSize()));
        this.func_110148_a(ModAttributes.ATTACK_RANGE).func_111128_a(-16.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        float size = 0.2f + this.field_70146_Z.nextFloat();
        this.func_184212_Q().func_187214_a(SIZE, (Object)Float.valueOf(Math.min(size, 1.0f)));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_70050_g(this.func_205010_bg());
        this.field_70125_A = 0.0f;
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("size", ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(compound.func_74760_g("size")));
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public float func_205022_a(BlockPos pos, IWorldReader world) {
        boolean flag1 = false;
        for (int i = 1; i < 3; ++i) {
            BlockState state = world.func_180495_p(pos.func_177979_c(i));
            if (state.func_185904_a() != Material.field_151586_h) continue;
            flag1 = true;
            break;
        }
        boolean flag2 = pos.func_177956_o() < 150;
        float weight = 64 / pos.func_177956_o() * 10;
        return flag1 && flag2 ? weight : 0.0f;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        BlockPos pos = new BlockPos((Entity)this);
        float weight = this.func_205022_a(pos, (IWorldReader)world);
        return weight > 0.0f;
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        this.func_209207_l(i);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public void func_213352_e(Vec3d positionIn) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), positionIn);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            } else {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.01, 0.0));
            }
        } else {
            super.func_213352_e(positionIn);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final FightingFishEntity fish;

        public MoveHelperController(FightingFishEntity fish) {
            super((MobEntity)fish);
            this.fish = fish;
        }

        public void func_75641_c() {
            if (this.fish.func_70090_H()) {
                this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.fish.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.field_75646_b - this.fish.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.fish.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.fish.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.fish.field_70761_aq = this.fish.field_70177_z = this.func_75639_a(this.fish.field_70177_z, f, 10.0f);
                    this.fish.field_70759_as = this.fish.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.fish.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    if (this.fish.func_70090_H()) {
                        this.fish.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.fish.field_70125_A = this.func_75639_a(this.fish.field_70125_A, f2, 5.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.fish.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.fish.field_70125_A * ((float)Math.PI / 180)));
                        this.fish.field_191988_bg = f3 * f1;
                        this.fish.field_70701_bs = -f4 * f1;
                    } else {
                        this.fish.func_70659_e(f1 * 0.1f);
                    }
                }
            } else {
                this.fish.func_70659_e(0.0f);
                this.fish.func_184646_p(0.0f);
                this.fish.func_70657_f(0.0f);
                this.fish.func_191989_p(0.0f);
            }
        }
    }
}

