/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.HumandrillEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.bandits.AbstractBanditEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.JumpAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.lapahn.LapahnRageGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.AbstractMarineEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.AbstractPirateEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.zou.GreatStompParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class LapahnEntity
extends OPEntity {
    private static final AttributeModifier RAGE_MODIFIER = new AttributeModifier(UUID.fromString("4b03a4b4-1eb5-464a-8312-0f9079044462"), "Rage Mode Multiplier", 10.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final DataParameter<Boolean> IS_ENRAGED = EntityDataManager.func_187226_a(LapahnEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final ParticleEffect PARTICLES = new GreatStompParticleEffect();

    public LapahnEntity(World world) {
        super(ModEntities.LAPAHN, world);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new JumpAttackGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LapahnRageGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractPirateEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractBanditEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractMarineEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, HumandrillEntity.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(55.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.setDoriki(10.0 + WyHelper.randomWithRange(0, 5));
        this.setBelly(0.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_ENRAGED, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("isEnraged", ((Boolean)this.field_70180_af.func_187225_a(IS_ENRAGED)).booleanValue());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(IS_ENRAGED, (Object)compound.func_74767_n("isEnraged"));
    }

    public boolean isEnraged() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ENRAGED);
    }

    public void setEnraged(boolean value) {
        this.field_70180_af.func_187227_b(IS_ENRAGED, (Object)value);
        IAttributeInstance attr = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        attr.func_111124_b(RAGE_MODIFIER);
        attr.func_111121_a(RAGE_MODIFIER);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (distance > 5.0f && !this.field_70170_p.field_72995_K) {
            PARTICLES.spawn(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            List<LivingEntity> targets = WyHelper.getEntitiesNear(this.func_180425_c(), this.field_70170_p, 5.0);
            targets.remove(this);
            float damage = 2.0f + (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            for (LivingEntity entity : targets) {
                if (entity instanceof LapahnEntity) continue;
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage);
                entity.func_213293_j(0.0, 0.5, 0.0);
                entity.field_70133_I = true;
            }
            return false;
        }
        return super.func_225503_b_(distance, damageMultiplier);
    }
}

