/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.CooldownGoal;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RetreatAndFlintlockGoal
extends CooldownGoal {
    private float animationTimer = 0.0f;
    private OPEntity entity;

    public RetreatAndFlintlockGoal(OPEntity entity, int timer, int random) {
        super(entity, timer, random);
        this.entity = entity;
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.entity.func_70638_az() == null) {
            return false;
        }
        if (this.entity.func_70644_a(ModEffects.MOVEMENT_BLOCKED)) {
            return false;
        }
        float distance = this.entity.func_70032_d((Entity)this.entity.func_70638_az());
        if (distance < 3.0f || distance > 35.0f) {
            return false;
        }
        if (!this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az())) {
            return false;
        }
        if (this.isOnCooldown()) {
            this.cooldownTick();
            return false;
        }
        this.execute();
        return true;
    }

    @Override
    public void endCooldown() {
        super.endCooldown();
        this.entity.setCurrentGoal(null);
        this.entity.setPreviousGoal(this);
        this.animationTimer = 0.0f;
    }

    public void execute() {
        this.entity.setAnimation(OPEntity.Animation.FLINTLOCK_POINTING.ordinal());
        this.animationTimer += 0.05f;
        if (this.entity.func_70638_az() == null) {
            this.entity.setCurrentGoal(this);
            this.setOnCooldown(true);
            this.entity.setAnimation(OPEntity.Animation.NONE.ordinal());
            return;
        }
        if (this.animationTimer < 0.2f) {
            Vec3d speed = WyHelper.propulsion(this.entity.func_70638_az(), 1.25, 1.25);
            this.entity.func_213293_j(speed.field_72450_a, 0.1, speed.field_72449_c);
        } else if (this.animationTimer >= 1.4f) {
            NormalBulletProjectile proj = new NormalBulletProjectile(this.entity.field_70170_p, (LivingEntity)this.entity);
            proj.setDamage(4.0f);
            LivingEntity target = this.entity.func_70638_az();
            double velX = target.func_226277_ct_() - this.entity.func_226277_ct_();
            double velY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - proj.func_226278_cu_();
            double velZ = target.func_226281_cx_() - this.entity.func_226281_cx_();
            double x = MathHelper.func_76133_a((double)(velX * velX + velZ * velZ));
            proj.func_70186_c(velX, velY + x * (double)0.1f, velZ, 1.6f, 15 - this.entity.field_70170_p.func_175659_aa().func_151525_a() * 4);
            this.entity.field_70170_p.func_217376_c((Entity)proj);
            this.entity.setCurrentGoal(this);
            this.setOnCooldown(true);
            this.entity.setAnimation(OPEntity.Animation.NONE.ordinal());
        }
    }
}

