/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.Difficulty;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.CooldownGoal;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.ShockwaveProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShockwaveAttackGoal
extends CooldownGoal {
    private OPEntity entity;
    private int hitCount;
    private int maxCount;
    private int duration;
    private final int maxDuration;
    private float prevHealth;
    private int animationId;
    private boolean canBreakBlocks;

    public ShockwaveAttackGoal(OPEntity entity, int cooldown, int hitCount, boolean canBreakBlocks) {
        super(entity, cooldown, (int)WyHelper.randomWithRange(5, 10));
        this.entity = entity;
        this.maxCount = hitCount;
        this.prevHealth = this.entity.func_110143_aJ();
        this.canBreakBlocks = canBreakBlocks;
        this.maxDuration = 5;
        this.entity.addThreat(2 + (this.canBreakBlocks ? 1 : 0));
    }

    public ShockwaveAttackGoal(OPEntity entity, int duration, int hitCount) {
        this(entity, duration, hitCount, false);
    }

    public ShockwaveAttackGoal(OPEntity entity, int duration) {
        this(entity, duration, 3, false);
    }

    public ShockwaveAttackGoal setAnimationId(int id) {
        this.animationId = id;
        return this;
    }

    @Override
    public boolean func_75250_a() {
        boolean hasEnemyInSight;
        if (this.entity.func_110143_aJ() < this.prevHealth) {
            ++this.hitCount;
            this.prevHealth = this.entity.func_110143_aJ();
        }
        boolean shouldExecute = super.func_75250_a() || this.hitCount >= this.maxCount;
        boolean hasMovement = !this.entity.func_70644_a(ModEffects.MOVEMENT_BLOCKED);
        boolean hasTarget = this.entity.func_70638_az() != null;
        boolean hasDistance = hasTarget && this.entity.func_70032_d((Entity)this.entity.func_70638_az()) > 10.0f;
        boolean bl = hasEnemyInSight = hasTarget && this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az());
        return shouldExecute && hasMovement && hasTarget && hasEnemyInSight && hasDistance;
    }

    public boolean func_75253_b() {
        ++this.duration;
        boolean continueExecution = false;
        if (this.duration < this.maxDuration) {
            continueExecution = true;
        }
        if (!continueExecution) {
            this.entity.setAnimation(0);
            this.hitCount = 0;
            this.maxCount = (int)Math.abs(WyHelper.randomWithRange(this.maxCount - 2, this.maxCount + 2));
            this.entity.setCurrentGoal(this);
            this.setOnCooldown(true);
        }
        return continueExecution;
    }

    @Override
    public void endCooldown() {
        super.endCooldown();
        this.entity.setCurrentGoal(null);
        this.entity.setPreviousGoal(this);
        this.duration = 0;
    }

    public void func_75249_e() {
        this.entity.setAnimation(this.animationId);
        double x = this.entity.func_70638_az().func_226277_ct_() - this.entity.func_226277_ct_() + (this.entity.field_70170_p.func_175659_aa().func_151525_a() >= Difficulty.HARD.func_151525_a() ? this.entity.func_70681_au().nextGaussian() : 0.0);
        double y = this.entity.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.entity.func_70638_az().func_213302_cg() / 2.0f) - (this.entity.func_226278_cu_() + (double)(this.entity.func_213302_cg() / 2.0f));
        double z = this.entity.func_70638_az().func_226281_cx_() - this.entity.func_226281_cx_() + (this.entity.field_70170_p.func_175659_aa().func_151525_a() >= Difficulty.HARD.func_151525_a() ? this.entity.func_70681_au().nextGaussian() : 0.0);
        ShockwaveProjectile proj = new ShockwaveProjectile(this.entity.field_70170_p, (LivingEntity)this.entity, this.canBreakBlocks);
        proj.func_70186_c(x, y, z, 1.5f, 0.0f);
        this.entity.field_70170_p.func_217376_c((Entity)proj);
    }
}

