/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.RainTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderboltTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderstormTempo;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.CoolBallProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.ThunderBallProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.WeatherBallProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.EntityCloud;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.artofweather.WeatherCloudChargedParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.artofweather.WeatherCloudParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class WeatherCloudEntity
extends EntityCloud {
    private static final ParticleEffect PARTICLES1 = new WeatherCloudParticleEffect();
    private static final ParticleEffect PARTICLES2 = new WeatherCloudChargedParticleEffect();
    private List<WeatherBallProjectile> weatherBalls = new ArrayList<WeatherBallProjectile>();
    private boolean charged = false;
    private boolean superCharged = false;

    public WeatherCloudEntity(World world) {
        super(world);
        this.setLife(200);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            RainTempo rainTempo;
            boolean canUseAbility;
            IAbilityData props = AbilityDataCapability.get(this.getThrower());
            if (this.field_70173_aa % 2 == 0) {
                PARTICLES1.spawn(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
                if (this.charged || this.superCharged) {
                    PARTICLES2.spawn(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
            if (this.getLife() <= 0 || this.getThrower() == null) {
                this.func_70106_y();
            }
            this.setLife(this.getLife() - 1);
            if (this.charged) {
                List<LivingEntity> targets = WyHelper.getEntitiesNear(this.func_180425_c().func_177979_c(15), this.field_70170_p, 9.0, LivingEntity.class);
                targets.remove(this.getThrower());
                targets = WyHelper.shuffle(targets);
                for (LivingEntity entity : targets) {
                    double l = Math.sqrt(this.func_70092_e(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()));
                    if (!(entity.func_226278_cu_() <= this.func_226278_cu_()) || this.field_70173_aa % 100 != 0 || !entity.func_70685_l((Entity)this)) continue;
                    LightningEntity bolt = new LightningEntity((Entity)this.getThrower(), entity.func_226277_ct_(), entity.func_226278_cu_() + 14.0, entity.func_226281_cx_(), 0.0f, 90.0f, (float)(l + 1.0), 5.0f);
                    bolt.setAngle(30);
                    bolt.setBranches(6);
                    bolt.setSegments(15);
                    bolt.setColor(new Color(253, 208, 35, 205));
                    bolt.setSize(this.superCharged ? 0.05f : 0.035f);
                    bolt.setExplosion(this.superCharged ? 1 : 0, false);
                    bolt.setDamage(this.superCharged ? 20.0f : 10.0f);
                    bolt.setAliveTicks(this.superCharged ? 20 : 10);
                    this.field_70170_p.func_217376_c((Entity)bolt);
                    if (!this.superCharged) break;
                    this.func_70106_y();
                }
            }
            List thunderBalls = this.weatherBalls.stream().filter(ball -> ball instanceof ThunderBallProjectile).collect(Collectors.toList());
            List coolBalls = this.weatherBalls.stream().filter(ball -> ball instanceof CoolBallProjectile).collect(Collectors.toList());
            ThunderstormTempo thunderstormTempo = props.getUnlockedAbility(ThunderstormTempo.INSTANCE);
            boolean bl = canUseAbility = thunderstormTempo != null && !thunderstormTempo.isOnCooldown() && thunderstormTempo.canUseTempo((PlayerEntity)this.getThrower(), (player, check) -> {
                if (!ItemsHelper.isClimaTact(this.getThrower().func_184614_ca())) {
                    return false;
                }
                ClimaTactItem climaTact = (ClimaTactItem)this.getThrower().func_184614_ca().func_77973_b();
                return climaTact.getLevel() >= 2 && !this.superCharged && this.charged && thunderBalls.size() >= 3;
            });
            if (canUseAbility) {
                thunderstormTempo.use((PlayerEntity)this.getThrower());
                this.superCharged = true;
                thunderstormTempo.startCooldown((PlayerEntity)this.getThrower());
                return;
            }
            ThunderboltTempo thunderboltTempo = props.getUnlockedAbility(ThunderboltTempo.INSTANCE);
            boolean bl2 = canUseAbility = thunderboltTempo != null && !thunderboltTempo.isOnCooldown() && thunderboltTempo.canUseTempo((PlayerEntity)this.getThrower(), (player, check) -> thunderBalls.size() > 0 && !this.charged);
            if (canUseAbility) {
                thunderboltTempo.use((PlayerEntity)this.getThrower());
                this.charged = true;
                int extraLife = 0;
                for (WeatherBallProjectile ball2 : thunderBalls) {
                    ball2.func_70106_y();
                    extraLife += 200;
                }
                thunderboltTempo.startCooldown((PlayerEntity)this.getThrower());
                this.setLife(this.getLife() + extraLife);
            }
            boolean bl3 = canUseAbility = (rainTempo = props.getUnlockedAbility(RainTempo.INSTANCE)) != null && rainTempo.canUseTempo((PlayerEntity)this.getThrower(), (player, check) -> coolBalls.size() >= 3);
            if (canUseAbility) {
                rainTempo.use((PlayerEntity)this.getThrower());
                for (WeatherBallProjectile cb : coolBalls) {
                    cb.func_70106_y();
                }
                this.func_70106_y();
            }
        }
    }

    public boolean isCharged() {
        return this.charged;
    }

    public boolean isSuperCharged() {
        return this.superCharged;
    }

    public void addWeatherBall(WeatherBallProjectile ball) {
        this.weatherBalls.add(ball);
    }
}

