/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg.CyborgProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class FreshFireProjectile
extends AbilityProjectileEntity {
    public FreshFireProjectile(World world) {
        super(CyborgProjectiles.FRESH_FIRE, world);
    }

    public FreshFireProjectile(EntityType type, World world) {
        super(type, world);
    }

    public FreshFireProjectile(World world, double x, double y, double z) {
        super(CyborgProjectiles.FRESH_FIRE, world, x, y, z);
    }

    public FreshFireProjectile(World world, LivingEntity player) {
        super(CyborgProjectiles.FRESH_FIRE, world, player);
        this.setDamage(1.0f);
        this.setPassThroughEntities();
        this.setMaxLife(15);
        this.setChangeHurtTime(true);
        this.setHurtTime(15);
        this.setDamageSource(DamageSource.field_76372_a);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        SetOnFireEvent event = new SetOnFireEvent(this.func_85052_h(), hitEntity, 10);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            hitEntity.func_70015_d(4);
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.placeBlockIfAllowed(this.field_70170_p, hit.func_177958_n(), hit.func_177956_o() + 1, hit.func_177952_p(), Blocks.field_150480_ab, AirBlockProtectionRule.INSTANCE);
    }

    private void onTickEvent() {
        for (int i = 0; i < 10; ++i) {
            double offsetX = WyHelper.randomDouble() / 2.0;
            double offsetY = WyHelper.randomDouble() / 2.0;
            double offsetZ = WyHelper.randomDouble() / 2.0;
            GenericParticleData data = new GenericParticleData(ModParticleTypes.MERA);
            data.setLife(5);
            data.setSize(0.7f);
            WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
        }
    }
}

