/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.doku;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doku.DokuProjectiles;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.EntityCloud;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.doku.ChloroBallCloudParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.doku.ChloroBallParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class ChloroBallProjectile
extends AbilityProjectileEntity {
    private static final ParticleEffect PARTICLES1 = new ChloroBallParticleEffect();
    private static final ParticleEffect PARTICLES2 = new ChloroBallCloudParticleEffect();

    public ChloroBallProjectile(World world) {
        super(DokuProjectiles.CHLORO_BALL, world);
    }

    public ChloroBallProjectile(EntityType type, World world) {
        super(type, world);
    }

    public ChloroBallProjectile(World world, double x, double y, double z) {
        super(DokuProjectiles.CHLORO_BALL, world, x, y, z);
    }

    public ChloroBallProjectile(World world, LivingEntity player) {
        super(DokuProjectiles.CHLORO_BALL, world, player);
        this.setDamage(7.0f);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        hitEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, 300, 0));
        this.onBlockImpactEvent.onImpact(hitEntity.func_180425_c());
    }

    private void onBlockImpactEvent(BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            double offsetX = WyHelper.randomWithRange(-3, 3);
            double offsetZ = WyHelper.randomWithRange(-3, 3);
            BlockPos location = new BlockPos(this.func_226277_ct_() + offsetX, this.func_226278_cu_(), this.func_226281_cx_() + offsetZ);
            if (!this.field_70170_p.func_180495_p(location.func_177977_b()).func_200132_m()) continue;
            AbilityHelper.placeBlockIfAllowed(this.field_70170_p, location.func_177958_n(), location.func_177956_o(), location.func_177952_p(), ModBlocks.POISON, DefaultProtectionRules.AIR_FOLIAGE);
        }
        PARTICLES1.spawn(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        ChloroBallCloudEntity smokeCloud = new ChloroBallCloudEntity(this.field_70170_p);
        smokeCloud.setLife(30);
        smokeCloud.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 0.0f, 0.0f);
        smokeCloud.func_213293_j(0.0, 0.0, 0.0);
        smokeCloud.setThrower(this.func_85052_h());
        this.field_70170_p.func_217376_c((Entity)smokeCloud);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                GenericParticleData data = new GenericParticleData(ModParticleTypes.DOKU);
                data.setLife(5);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }

    public static class ChloroBallCloudEntity
    extends EntityCloud {
        public ChloroBallCloudEntity(World world) {
            super(world);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K) {
                for (LivingEntity target : WyHelper.getEntitiesNear(this.func_180425_c(), this.field_70170_p, 5.0)) {
                    if (this.getThrower() == target || !target.func_70644_a(Effects.field_76436_u)) continue;
                    target.func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 1));
                }
                if (this.field_70173_aa % 2 == 0) {
                    PARTICLES2.spawn(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

