/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.doku;

import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doku.DokuProjectiles;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class HydraProjectile
extends AbilityProjectileEntity {
    private boolean teleport = false;

    public HydraProjectile(World world) {
        super(DokuProjectiles.HYDRA, world);
    }

    public HydraProjectile(EntityType type, World world) {
        super(type, world);
    }

    public HydraProjectile(World world, double x, double y, double z) {
        super(DokuProjectiles.HYDRA, world, x, y, z);
    }

    public HydraProjectile(World world, LivingEntity player, boolean teleport) {
        super(DokuProjectiles.HYDRA, world, player);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.setDamage(teleport ? 8.0f : 20.0f);
        this.setMaxLife(teleport ? 30 : 15);
        this.setPassThroughEntities();
        this.teleport = teleport;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onBlockImpactEvent(BlockPos pos) {
        if (this.teleport) {
            if (this.func_85052_h() == null) {
                return;
            }
            BlockState state = this.func_85052_h().field_70170_p.func_180495_p(pos);
            if (state.func_177230_c().isAir(state, (IBlockReader)this.field_70170_p, pos)) {
                return;
            }
            if (this.func_85052_h().func_184187_bx() != null) {
                this.func_85052_h().func_184210_p();
            }
            this.func_85052_h().func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p());
            this.func_85052_h().field_70143_R = 0.0f;
        }
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        hitEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, 500, 1));
    }
}

