/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.fishmankarate;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.fishmankarate.FishmanKarateProjectiles;
import xyz.pixelatedw.mineminenomi.particles.effects.common.WaterExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class UchimizuProjectile
extends AbilityProjectileEntity {
    public UchimizuProjectile(World world) {
        super(FishmanKarateProjectiles.UCHIMIZU, world);
    }

    public UchimizuProjectile(EntityType type, World world) {
        super(type, world);
    }

    public UchimizuProjectile(World world, double x, double y, double z) {
        super(FishmanKarateProjectiles.UCHIMIZU, world, x, y, z);
    }

    public UchimizuProjectile(World world, LivingEntity player) {
        super(FishmanKarateProjectiles.UCHIMIZU, world, player);
        this.setDamage(2.0f);
        this.setMaxLife(30);
        this.setChangeHurtTime(true);
        this.setHurtTime(10);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 1.0f);
        explosion.setExplosionSound(false);
        explosion.setDamageOwner(false);
        explosion.disableExplosionKnockback();
        explosion.setDestroyBlocks(false);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles(new WaterExplosionParticleEffect());
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197630_w, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ, 1, 0.0, 0.0, 0.0, -0.1);
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

