/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.mera;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.SnowLayerBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.MeraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class HikenProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(LiquidBlockProtectionRule.INSTANCE, SnowLayerBlockProtectionRule.INSTANCE);

    public HikenProjectile(World world) {
        super(MeraProjectiles.HIKEN, world);
    }

    public HikenProjectile(EntityType type, World world) {
        super(type, world);
    }

    public HikenProjectile(World world, double x, double y, double z) {
        super(MeraProjectiles.HIKEN, world, x, y, z);
    }

    public HikenProjectile(World world, LivingEntity player) {
        super(MeraProjectiles.HIKEN, world, player);
        this.setDamage(50.0f);
        this.setCanGetStuckInGround();
        this.setPassThroughEntities();
        this.setMaxLife(32);
        this.setDamageSource(ModDamageSource.FIRE.causeIndirectDamageFromSource(this));
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 3.0f);
        explosion.setStaticDamage(25.0f);
        explosion.setHeightDifference(30);
        explosion.disableExplosionKnockback();
        explosion.setFireAfterExplosion(true);
        explosion.setExplosionSound(false);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
        explosion.func_199592_a(ModDamageSource.FIRE.causeIndirectDamageFromSource(this));
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (this.field_70173_aa > 2) {
            BlockPos pos = this.func_180425_c();
            this.onBlockImpactEvent.onImpact(pos);
        }
        if (this.func_208600_a(FluidTags.field_206959_a) && CommonConfig.INSTANCE.getDestroyWater()) {
            List<BlockPos> coords = AbilityHelper.createFilledSphere(this.func_130014_f_(), (int)this.func_226277_ct_(), (int)this.func_226278_cu_(), (int)this.func_226281_cx_(), 2, Blocks.field_150350_a, GRIEF_RULE);
            for (BlockPos blockPos : coords) {
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197612_e, (ServerWorld)this.func_130014_f_(), (double)blockPos.func_177958_n() + WyHelper.randomDouble() / 2.0, (double)blockPos.func_177956_o() + 0.8, (double)blockPos.func_177952_p() + WyHelper.randomDouble() / 2.0);
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o() + 1.1, (double)blockPos.func_177952_p(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            GenericParticleData data;
            double offsetZ;
            double offsetY;
            int i;
            for (i = 0; i < 20; ++i) {
                double offsetX = WyHelper.randomDouble() * 2.0;
                offsetY = WyHelper.randomDouble() * 2.0;
                offsetZ = WyHelper.randomDouble() * 2.0;
                data = new GenericParticleData(ModParticleTypes.MERA);
                data.setMotion(this.func_213322_ci().field_72450_a / 10.0, this.func_213322_ci().field_72448_b / 10.0, this.func_213322_ci().field_72449_c / 10.0);
                data.setLife(60);
                data.setSize(3.0f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
            for (i = 0; i < 10; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                offsetY = WyHelper.randomDouble() / 2.0;
                offsetZ = WyHelper.randomDouble() / 2.0;
                data = new GenericParticleData(ModParticleTypes.MOKU);
                data.setLife(7);
                data.setSize(1.2f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

