/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.sniper;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.sniper.SniperProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class KaenBoshiProjectile
extends AbilityProjectileEntity {
    public KaenBoshiProjectile(World world) {
        super(SniperProjectiles.KAEN_BOSHI, world);
    }

    public KaenBoshiProjectile(EntityType type, World world) {
        super(type, world);
    }

    public KaenBoshiProjectile(World world, double x, double y, double z) {
        super(SniperProjectiles.KAEN_BOSHI, world, x, y, z);
    }

    public KaenBoshiProjectile(World world, LivingEntity player) {
        super(SniperProjectiles.KAEN_BOSHI, world, player);
        this.setDamage(8.0f);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        if (hitEntity instanceof CreeperEntity) {
            ((CreeperEntity)hitEntity).func_146079_cb();
            return;
        }
        SetOnFireEvent event = new SetOnFireEvent(this.func_85052_h(), hitEntity, 10);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            hitEntity.func_70015_d(10);
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        if (this.field_70170_p.func_180495_p(hit).func_177230_c() == ModBlocks.OIL_SPILL) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 4.0f);
            explosion.setStaticDamage(10.0f);
            explosion.setFireAfterExplosion(true);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(4));
            explosion.doExplosion();
            return;
        }
        AbilityHelper.placeBlockIfAllowed(this.field_70170_p, hit.func_177958_n(), hit.func_177956_o() + 1, hit.func_177952_p(), Blocks.field_150480_ab, AirBlockProtectionRule.INSTANCE);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 5.0;
                double offsetY = WyHelper.randomDouble() / 5.0;
                double offsetZ = WyHelper.randomDouble() / 5.0;
                GenericParticleData data = new GenericParticleData(ModParticleTypes.MERA);
                data.setLife(10);
                data.setSize(0.5f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 0.2 + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

