/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.yami;

import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yami.YamiProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.yami.DarkMatterChargingParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class BlackRoadProjectile
extends AbilityProjectileEntity {
    private static final ParticleEffect PARTICLES = new DarkMatterChargingParticleEffect();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(CoreBlockProtectionRule.INSTANCE);

    public BlackRoadProjectile(World world) {
        super(YamiProjectiles.BLACK_ROAD, world);
    }

    public BlackRoadProjectile(EntityType type, World world) {
        super(type, world);
    }

    public BlackRoadProjectile(World world, double x, double y, double z) {
        super(YamiProjectiles.BLACK_ROAD, world, x, y, z);
    }

    public BlackRoadProjectile(World world, LivingEntity player) {
        super(YamiProjectiles.BLACK_ROAD, world, player);
        this.setMaxLife(1);
        this.setDamage(10.0f);
        this.setPassThroughEntities();
        this.setPassThroughBlocks();
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        BlockPos pos = null;
        int j = 1;
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177979_c(j));
            if (state.func_200132_m()) {
                pos = this.func_180425_c().func_177979_c(j);
                break;
            }
            if (j > 2) break;
            ++j;
        }
        if (pos == null) {
            return;
        }
        int size = 2 + 4 * (this.getMaxLife() - this.getLife()) / this.getMaxLife();
        AbilityHelper.createFilledSphere(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), size, ModBlocks.DARKNESS, GRIEF_RULE);
        PARTICLES.spawn(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0, 0.0, 0.0);
    }
}

