/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.yuki;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yuki.YukiProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class YukiRabiProjectile
extends AbilityProjectileEntity {
    public YukiRabiProjectile(World world) {
        super(YukiProjectiles.YUKI_RABI, world);
    }

    public YukiRabiProjectile(EntityType type, World world) {
        super(type, world);
    }

    public YukiRabiProjectile(World world, double x, double y, double z) {
        super(YukiProjectiles.YUKI_RABI, world, x, y, z);
    }

    public YukiRabiProjectile(World world, LivingEntity player) {
        super(YukiProjectiles.YUKI_RABI, world, player);
        this.setDamage(3.5f);
        this.setChangeHurtTime(true);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.onTickEvent = this::onTickEvent;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        AbilityHelper.addFrostbite(entity, this.func_85052_h(), 15);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 5.0;
                double offsetY = WyHelper.randomDouble() / 5.0;
                double offsetZ = WyHelper.randomDouble() / 5.0;
                ParticleType<GenericParticleData> particle = i % 2 == 0 ? ModParticleTypes.YUKI2 : ModParticleTypes.YUKI;
                GenericParticleData data = new GenericParticleData(particle);
                data.setLife(20);
                data.setSize(1.3f);
                data.setMotion(0.0, -0.02, 0.0);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 0.25 + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

