/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.passives;

import java.awt.Color;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.doru.DoruDoruBallAbility;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.models.abilities.CandleLockModel;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.models.SphereModel;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class DoruPassiveEvents {

    @Mod.EventBusSubscriber(modid="mineminenomi")
    public static class CommonEvents {
        @SubscribeEvent
        public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
            boolean isDoruBallActive;
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
            DoruDoruBallAbility doruBallAbility = abilityProps.getEquippedAbility(DoruDoruBallAbility.INSTANCE);
            boolean bl = isDoruBallActive = doruBallAbility != null && doruBallAbility.isContinuous();
            if (isDoruBallActive) {
                player.func_213293_j(0.0, -5.0, 0.0);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
    public static class ClientEvents {
        private static final String[] COLORS = new String[]{"#c21d1f", "#8f176b", "#4d178f", "#17508d", "#158d7b", "#128d21", "#c8cb17", "#5ae163"};
        private static Color randomColor1 = ClientEvents.chooseRandomColor();
        private static Color randomColor2 = ClientEvents.chooseRandomColor();
        private static final SphereModel DORU_BALL = new SphereModel();
        private static final CandleLockModel CANDLE_LOCK = new CandleLockModel();

        private static Color chooseRandomColor() {
            int i = (int)WyHelper.randomWithRange(0, COLORS.length - 1);
            String hex = COLORS[i];
            return WyHelper.hexToRGB(hex);
        }

        @SubscribeEvent
        public static void onEntityRendered(RenderLivingEvent.Pre event) {
            LivingEntity entity = event.getEntity();
            Color color = Color.WHITE;
            if (!entity.func_70644_a(ModEffects.CANDLE_LOCK)) {
                return;
            }
            if (entity.func_70660_b(ModEffects.CANDLE_LOCK).func_76459_b() <= 0) {
                entity.func_195063_d(ModEffects.CANDLE_LOCK);
                return;
            }
            if (entity.func_70660_b(ModEffects.CANDLE_LOCK).func_76458_c() == 2) {
                color = randomColor1;
            }
            event.getMatrixStack().func_227860_a_();
            event.getMatrixStack().func_227861_a_(0.0, -0.8, 0.0);
            event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229180_c_, entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * event.getPartialRenderTick() + 180.0f, true));
            CANDLE_LOCK.func_225598_a_(event.getMatrixStack(), event.getBuffers().getBuffer(ModRenderTypes.getAbilityHand(ModResources.CANDLE_LOCK)), event.getLight(), 0, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
            event.getMatrixStack().func_227865_b_();
        }

        @SubscribeEvent
        public static void onPlayerRendered(RenderPlayerEvent.Pre event) {
            boolean isActive;
            PlayerEntity player = event.getPlayer();
            IAbilityData data = AbilityDataCapability.get((LivingEntity)player);
            Color color = Color.WHITE;
            DoruDoruBallAbility ability = data.getEquippedAbility(DoruDoruBallAbility.INSTANCE);
            boolean bl = isActive = ability != null && ability.isContinuous();
            if (isActive) {
                event.setCanceled(true);
                if (event.getPlayer().field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.COLOR_PALETTE))) {
                    color = randomColor2;
                }
                DoruDoruBallAbility abl = ability;
                abl.rotateAngleX += player.func_213322_ci().field_72449_c;
                abl.rotateAngleZ -= player.func_213322_ci().field_72450_a;
                event.getMatrixStack().func_227860_a_();
                event.getMatrixStack().func_227861_a_(0.0, (double)(player.func_70047_e() - 0.5f), 0.0);
                event.getMatrixStack().func_227862_a_(8.0f, 8.0f, 8.0f);
                DORU_BALL.setRotateAngle(ClientEvents.DORU_BALL.shape1, (float)abl.rotateAngleX, 0.0f, (float)abl.rotateAngleZ);
                DORU_BALL.func_225598_a_(event.getMatrixStack(), event.getBuffers().getBuffer(ModRenderTypes.getAbilityBody(ModResources.CANDLE_LOCK)), event.getLight(), 0, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
                event.getMatrixStack().func_227865_b_();
            }
        }
    }
}

