/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.init;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.effects.GuardingEffect;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class ModAttributes {
    public static final IAttribute FALL_RESISTANCE = new RangedAttribute(null, "mineminenomi.fallResistance", 0.0, -256.0, 256.0).func_111117_a("Fall Resistance");
    public static final IAttribute JUMP_HEIGHT = new RangedAttribute(null, "mineminenomi.jumpHeight", 1.0, -256.0, 256.0).func_111117_a("Jump Height").func_111112_a(true);
    public static final IAttribute REGEN_RATE = new RangedAttribute(null, "mineminenomi.regenRate", 1.0, 0.0, 32.0).func_111117_a("Regen Rate").func_111112_a(true);
    public static final IAttribute STEP_HEIGHT = new RangedAttribute(null, "mineminenomi.stepHeight", 0.5, 0.0, 20.0).func_111117_a("Step Height").func_111112_a(true);
    public static final IAttribute DAMAGE_REDUCTION = new RangedAttribute(null, "mineminenomi.damageReduction", 0.0, -2.0, 0.999).func_111117_a("Damage Reduction").func_111112_a(true);
    public static final IAttribute ATTACK_RANGE = new RangedAttribute(null, "mineminenomi.attackRange", 0.0, -1024.0, 1024.0).func_111117_a("Attack Range").func_111112_a(true);

    @SubscribeEvent
    public static void onEntityConstruct(EntityEvent.EntityConstructing entity) {
        if (entity.getEntity() instanceof LivingEntity) {
            ((LivingEntity)entity.getEntity()).func_110140_aT().func_111150_b(FALL_RESISTANCE);
            ((LivingEntity)entity.getEntity()).func_110140_aT().func_111150_b(JUMP_HEIGHT);
            ((LivingEntity)entity.getEntity()).func_110140_aT().func_111150_b(REGEN_RATE);
            ((LivingEntity)entity.getEntity()).func_110140_aT().func_111150_b(STEP_HEIGHT);
            ((LivingEntity)entity.getEntity()).func_110140_aT().func_111150_b(DAMAGE_REDUCTION);
            ((LivingEntity)entity.getEntity()).func_110140_aT().func_111150_b(ATTACK_RANGE);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent e) {
        if (!e.player.field_70170_p.field_72995_K) {
            return;
        }
        IAttributeInstance attributeInstance = e.player.func_110148_a(STEP_HEIGHT);
        e.player.field_70138_W = (float)attributeInstance.func_111126_e();
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent e) {
        IAttributeInstance attributeInstance = e.getEntityLiving().func_110148_a(FALL_RESISTANCE);
        e.setDistance((float)((double)e.getDistance() - attributeInstance.func_111126_e()));
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent e) {
        double value = e.getEntityLiving().func_110148_a(JUMP_HEIGHT).func_111126_e();
        e.getEntityLiving().func_70024_g(0.0, (double)0.1f * (value - 1.0), 0.0);
        if (value <= 0.0) {
            e.getEntityLiving().func_213293_j(0.0, e.getEntityLiving().func_213322_ci().field_72448_b, 0.0);
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent e) {
        if (e.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        double reduction = e.getEntityLiving().func_110148_a(DAMAGE_REDUCTION).func_111126_e();
        int absoluteReduction = 60;
        if (reduction > 0.0 && e.getSource().func_76363_c()) {
            for (EffectInstance effectInstance : e.getEntityLiving().func_70651_bq()) {
                if (!(effectInstance.func_188419_a() instanceof GuardingEffect)) continue;
                absoluteReduction = (int)(50.0 - (double)effectInstance.func_76458_c() * 2.5);
            }
            reduction /= (double)absoluteReduction;
        }
        e.setAmount((float)((double)e.getAmount() * (1.0 - reduction)));
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        float value = (float)event.getEntityLiving().func_110148_a(REGEN_RATE).func_111126_e();
        if (value != 1.0f) {
            event.setAmount(event.getAmount() * value);
        }
    }
}

