/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.init;

import java.util.Map;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.entities.BombEntity;
import xyz.pixelatedw.mineminenomi.entities.DFItemEntity;
import xyz.pixelatedw.mineminenomi.entities.PhysicalBodyEntity;
import xyz.pixelatedw.mineminenomi.entities.SpikeEntity;
import xyz.pixelatedw.mineminenomi.entities.VivreCardEntity;
import xyz.pixelatedw.mineminenomi.entities.WantedPosterPackageEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.SkypieanCivilianEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.SkypieanTraderEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.BlackKnightEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.DoppelmanEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.MirageCloneEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.WaxCloneEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.DenDenMushiEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.FightingFishEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.HumandrillEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.KungFuDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.LapahnEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.SeaKingEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.YagaraBullEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.bandits.BanditBomberEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.bandits.BanditBruteEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.bandits.BanditSniperEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.bandits.BanditWithSwordEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.MarineBomberEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.MarineCaptainEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.MarineSniperEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.MarineTraderEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.MarineWithGunEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.MarineWithSwordEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.MorganEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.PirateBruteEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.PirateCaptainEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.PirateTraderEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.PirateWithGunEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.PirateWithSwordEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates.DonKriegEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates.GinEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.ArtOfWeatherTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.BlackLegTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.BrawlerTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.DoctorTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.SniperTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.SwordsmanTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.objectives.SniperTargetEntity;
import xyz.pixelatedw.mineminenomi.wypi.ModdedSpawnEggItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final EntityClassification MARINES = EntityClassification.create((String)"marines", (String)"marines", (int)2, (boolean)false, (boolean)false);
    public static final EntityClassification PIRATES = EntityClassification.create((String)"pirates", (String)"pirates", (int)2, (boolean)false, (boolean)false);
    public static final EntityClassification BANDITS = EntityClassification.create((String)"bandits", (String)"bandits", (int)2, (boolean)false, (boolean)false);
    public static final EntityType MARINE_WITH_SWORD = WyRegistry.createEntityType(MarineWithSwordEntity::new, MARINES).func_206830_a("marine_with_sword");
    public static final EntityType MARINE_WITH_GUN = WyRegistry.createEntityType(MarineWithGunEntity::new, MARINES).func_206830_a("marine_with_gun");
    public static final EntityType MARINE_SNIPER = WyRegistry.createEntityType(MarineSniperEntity::new, MARINES).func_206830_a("marine_sniper");
    public static final EntityType MARINE_BOMBER = WyRegistry.createEntityType(MarineBomberEntity::new, MARINES).func_220321_a(0.8f, 2.3f).func_206830_a("marine_bomber");
    public static final EntityType MARINE_CAPTAIN = WyRegistry.createEntityType(MarineCaptainEntity::new, MARINES).func_206830_a("marine_captain");
    public static final EntityType MARINE_TRADER = WyRegistry.createEntityType(MarineTraderEntity::new, MARINES).func_206830_a("marine_trader");
    public static final EntityType MORGAN = WyRegistry.createEntityType(MorganEntity::new, MARINES).func_220321_a(0.8f, 2.1f).func_206830_a("morgan");
    public static final EntityType PIRATE_WITH_SWORD = WyRegistry.createEntityType(PirateWithSwordEntity::new, PIRATES).func_206830_a("pirate_with_sword");
    public static final EntityType PIRATE_WITH_GUN = WyRegistry.createEntityType(PirateWithGunEntity::new, PIRATES).func_206830_a("pirate_with_gun");
    public static final EntityType PIRATE_BRUTE = WyRegistry.createEntityType(PirateBruteEntity::new, PIRATES).func_220321_a(0.8f, 2.3f).func_206830_a("pirate_brute");
    public static final EntityType PIRATE_CAPTAIN = WyRegistry.createEntityType(PirateCaptainEntity::new, PIRATES).func_206830_a("pirate_captain");
    public static final EntityType PIRATE_TRADER = WyRegistry.createEntityType(PirateTraderEntity::new, PIRATES).func_206830_a("pirate_trader");
    public static final EntityType GIN = WyRegistry.createEntityType(GinEntity::new).func_206830_a("gin");
    public static final EntityType DON_KRIEG = WyRegistry.createEntityType(DonKriegEntity::new).func_220321_a(0.8f, 2.1f).func_206830_a("don_krieg");
    public static final EntityType BANDIT_WITH_SWORD = WyRegistry.createEntityType(BanditWithSwordEntity::new, BANDITS).func_206830_a("bandit_with_sword");
    public static final EntityType BANDIT_SNIPER = WyRegistry.createEntityType(BanditSniperEntity::new, BANDITS).func_206830_a("bandit_sniper");
    public static final EntityType BANDIT_BRUTE = WyRegistry.createEntityType(BanditBruteEntity::new, BANDITS).func_220321_a(0.8f, 2.3f).func_206830_a("bandit_brute");
    public static final EntityType BANDIT_BOMBER = WyRegistry.createEntityType(BanditBomberEntity::new, BANDITS).func_220321_a(0.8f, 2.3f).func_206830_a("bandit_bomber");
    public static final EntityType SWORDSMAN_TRAINER = WyRegistry.createEntityType(SwordsmanTrainerEntity::new).func_206830_a("swordsman_trainer");
    public static final EntityType SNIPER_TRAINER = WyRegistry.createEntityType(SniperTrainerEntity::new).func_206830_a("sniper_trainer");
    public static final EntityType ART_OF_WEATHER_TRAINER = WyRegistry.createEntityType(ArtOfWeatherTrainerEntity::new).func_206830_a("art_of_weather_trainer");
    public static final EntityType DOCTOR_TRAINER = WyRegistry.createEntityType(DoctorTrainerEntity::new).func_206830_a("doctor_trainer");
    public static final EntityType BRAWLER_TRAINER = WyRegistry.createEntityType(BrawlerTrainerEntity::new).func_206830_a("brawler_trainer");
    public static final EntityType BLACK_LEG_TRAINER = WyRegistry.createEntityType(BlackLegTrainerEntity::new).func_206830_a("black_leg_trainer");
    public static final EntityType SKYPIEAN_CIVILIAN = WyRegistry.createEntityType(SkypieanCivilianEntity::new).func_206830_a("skypiean_civilian");
    public static final EntityType SKYPIEAN_TRADER = WyRegistry.createEntityType(SkypieanTraderEntity::new).func_206830_a("skypiean_trader");
    public static final EntityType DEN_DEN_MUSHI = WyRegistry.createEntityType(DenDenMushiEntity::new).func_220321_a(0.8f, 0.8f).func_206830_a("den_den_mushi");
    public static final EntityType LAPAHN = WyRegistry.createEntityType(LapahnEntity::new, EntityClassification.CREATURE).func_220321_a(0.8f, 2.5f).func_206830_a("lapahn");
    public static final EntityType KUNG_FU_DUGONG = WyRegistry.createEntityType(KungFuDugongEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 1.2f).func_206830_a("kung_fu_dugong");
    public static final EntityType YAGARA_BULL = WyRegistry.createEntityType(YagaraBullEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(1.4f, 1.6f).func_206830_a("yagara_bull");
    public static final EntityType SEA_KING = WyRegistry.createEntityType(SeaKingEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(3.0f, 3.0f).func_206830_a("sea_king");
    public static final EntityType HUMANDRILL = WyRegistry.createEntityType(HumandrillEntity::new, EntityClassification.CREATURE).func_220321_a(1.0f, 2.5f).func_206830_a("humandrill");
    public static final EntityType FIGHTING_FISH = WyRegistry.createEntityType(FightingFishEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(3.0f, 3.0f).func_206830_a("fighting_fish");
    public static final EntityType DOPPELMAN = WyRegistry.createEntityType(DoppelmanEntity::new).func_206830_a("doppelman");
    public static final EntityType WAX_CLONE = WyRegistry.createEntityType(WaxCloneEntity::new).func_206830_a("wax_clone");
    public static final EntityType BLACK_KNIGHT = WyRegistry.createEntityType(BlackKnightEntity::new).func_206830_a("black_knight");
    public static final EntityType WANTED_POSTER_PACKAGE = WyRegistry.createEntityType(WantedPosterPackageEntity::new).func_220321_a(1.5f, 1.5f).func_206830_a("wanted_poster_package");
    public static final EntityType VIVRE_CARD = WyRegistry.createEntityType(VivreCardEntity::new).func_220321_a(0.4f, 0.4f).func_206830_a("vivre_card");
    public static final EntityType PHYSICAL_BODY = WyRegistry.createEntityType(PhysicalBodyEntity::new).func_206830_a("physical_body");
    public static final EntityType SNIPER_TARGET = WyRegistry.createEntityType(SniperTargetEntity::new).func_206830_a("sniper_target");
    public static final EntityType MIRAGE_CLONE = WyRegistry.createEntityType(MirageCloneEntity::new).func_206830_a("mirage_clone");
    public static final EntityType BOMB = WyRegistry.createEntityType(BombEntity::new).func_220321_a(0.8f, 0.8f).func_206830_a("bomb");
    public static final EntityType DEVIL_FRUIT_ITEM = WyRegistry.createEntityType(DFItemEntity::new).func_206830_a("df_item");
    public static final EntityType SPIKE = WyRegistry.createEntityType(SpikeEntity::new).func_220321_a(0.2f, 0.2f).func_206830_a("spike");
    private static final Biome.Category[] GENERIC_ONES = new Biome.Category[]{Biome.Category.PLAINS, Biome.Category.FOREST, Biome.Category.BEACH, Biome.Category.EXTREME_HILLS, Biome.Category.TAIGA, Biome.Category.SAVANNA, Biome.Category.SWAMP};
    private static final Biome.Category[] PIRATE_BIOMES = new Biome.Category[]{Biome.Category.BEACH, Biome.Category.SWAMP, Biome.Category.FOREST};
    private static final Biome.Category[] MARINE_BIOMES = new Biome.Category[]{Biome.Category.PLAINS, Biome.Category.TAIGA, Biome.Category.FOREST, Biome.Category.SAVANNA, Biome.Category.BEACH, Biome.Category.SWAMP};
    private static final Biome.Category[] BANDIT_BIOMES = new Biome.Category[]{Biome.Category.EXTREME_HILLS, Biome.Category.FOREST, Biome.Category.MESA};

    public static void registerEntityWorldSpawn(EntityType<?> type, int weight, int minGroup, int maxGroup, Biome.Category ... categories) {
        if (!((Boolean)CommonConfig.INSTANCE.canSpawnWorldNPCs.get()).booleanValue()) {
            return;
        }
        for (Map.Entry entry : ForgeRegistries.BIOMES.getEntries()) {
            for (Biome.Category category : categories) {
                if (entry == null || ((Biome)entry.getValue()).func_201856_r() != category) continue;
                ((Biome)entry.getValue()).func_76747_a(type.func_220339_d()).add(new Biome.SpawnListEntry(type, weight, minGroup, maxGroup));
            }
        }
    }

    public static void registerEntityWorldSpawn(EntityType<?> type, int weight, int minGroup, int maxGroup, Biome ... biomes) {
        if (!((Boolean)CommonConfig.INSTANCE.canSpawnWorldNPCs.get()).booleanValue()) {
            return;
        }
        for (Biome biome : biomes) {
            if (biome == null) continue;
            biome.func_76747_a(type.func_220339_d()).add(new Biome.SpawnListEntry(type, weight, minGroup, maxGroup));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPostRegisterEntities(RegistryEvent.Register<EntityType<?>> event) {
        ModdedSpawnEggItem.initUnaddedEggs();
    }

    private static Item registerMarineWithSpawnEgg(EntityType type, String name) {
        WyRegistry.registerEntityType(type, name);
        return WyRegistry.registerSpawnEggItem(type, name, WyHelper.hexToRGB("#024a81").getRGB(), WyHelper.hexToRGB("#F7F7F7").getRGB());
    }

    private static Item registerPirateWithSpawnEgg(EntityType type, String name) {
        WyRegistry.registerEntityType(type, name);
        return WyRegistry.registerSpawnEggItem(type, name, WyHelper.hexToRGB("#c11c1c").getRGB(), WyHelper.hexToRGB("#F7F7F7").getRGB());
    }

    private static Item registerBanditWithSpawnEgg(EntityType type, String name) {
        WyRegistry.registerEntityType(type, name);
        return WyRegistry.registerSpawnEggItem(type, name, WyHelper.hexToRGB("#785355").getRGB(), WyHelper.hexToRGB("#F7F7F7").getRGB());
    }

    private static Item registerFactionlessWithSpawnEgg(EntityType type, String name) {
        WyRegistry.registerEntityType(type, name);
        return WyRegistry.registerSpawnEggItem(type, name, WyHelper.hexToRGB("#fbbf4c").getRGB(), WyHelper.hexToRGB("#F7F7F7").getRGB());
    }

    private static Item registerAnimalWithSpawnEgg(EntityType type, String name) {
        WyRegistry.registerEntityType(type, name);
        return WyRegistry.registerSpawnEggItem(type, name, WyHelper.hexToRGB("#a7ca34").getRGB(), WyHelper.hexToRGB("#a2f7c8").getRGB());
    }

    private static Item registerDummyWithSpawnEgg(EntityType type, String name) {
        WyRegistry.registerEntityType(type, name);
        return WyRegistry.registerSpawnEggItem(type, name, WyHelper.hexToRGB("#FF00DD").getRGB(), WyHelper.hexToRGB("#EEFF00").getRGB());
    }

    static {
        ModEntities.registerMarineWithSpawnEgg(MARINE_WITH_SWORD, "Marine with Sword");
        ModEntities.registerEntityWorldSpawn(MARINE_WITH_SWORD, 10, 0, 3, MARINE_BIOMES);
        ModEntities.registerMarineWithSpawnEgg(MARINE_WITH_GUN, "Marine with Gun");
        ModEntities.registerEntityWorldSpawn(MARINE_WITH_GUN, 5, 0, 2, MARINE_BIOMES);
        ModEntities.registerMarineWithSpawnEgg(MARINE_SNIPER, "Marine Sniper");
        ModEntities.registerEntityWorldSpawn(MARINE_SNIPER, 1, 0, 1, MARINE_BIOMES);
        ModEntities.registerMarineWithSpawnEgg(MARINE_BOMBER, "Marine Bomber");
        ModEntities.registerEntityWorldSpawn(MARINE_BOMBER, 1, 0, 2, MARINE_BIOMES);
        ModEntities.registerMarineWithSpawnEgg(MARINE_CAPTAIN, "Marine Captain");
        ModEntities.registerMarineWithSpawnEgg(MARINE_TRADER, "Marine Trader");
        WyRegistry.registerEntityType(MORGAN, "Morgan");
        ModEntities.registerPirateWithSpawnEgg(PIRATE_WITH_SWORD, "Pirate with Sword");
        ModEntities.registerEntityWorldSpawn(PIRATE_WITH_SWORD, 10, 0, 3, PIRATE_BIOMES);
        ModEntities.registerPirateWithSpawnEgg(PIRATE_WITH_GUN, "Pirate with Gun");
        ModEntities.registerEntityWorldSpawn(PIRATE_WITH_GUN, 5, 0, 2, PIRATE_BIOMES);
        ModEntities.registerPirateWithSpawnEgg(PIRATE_BRUTE, "Pirate Brute");
        ModEntities.registerEntityWorldSpawn(PIRATE_BRUTE, 2, 0, 2, PIRATE_BIOMES);
        ModEntities.registerPirateWithSpawnEgg(PIRATE_CAPTAIN, "Pirate Captain");
        ModEntities.registerPirateWithSpawnEgg(PIRATE_TRADER, "Pirate Trader");
        WyRegistry.registerEntityType(GIN, "Gin");
        WyRegistry.registerEntityType(DON_KRIEG, "Don Krieg");
        ModEntities.registerBanditWithSpawnEgg(BANDIT_WITH_SWORD, "Bandit with Sword");
        ModEntities.registerEntityWorldSpawn(BANDIT_WITH_SWORD, 10, 0, 5, BANDIT_BIOMES);
        ModEntities.registerBanditWithSpawnEgg(BANDIT_BRUTE, "Bandit Brute");
        ModEntities.registerEntityWorldSpawn(BANDIT_BRUTE, 2, 0, 2, BANDIT_BIOMES);
        ModEntities.registerBanditWithSpawnEgg(BANDIT_SNIPER, "Bandit Sniper");
        ModEntities.registerEntityWorldSpawn(BANDIT_SNIPER, 1, 0, 1, BANDIT_BIOMES);
        ModEntities.registerBanditWithSpawnEgg(BANDIT_BOMBER, "Bandit Bomber");
        ModEntities.registerEntityWorldSpawn(BANDIT_BOMBER, 1, 0, 2, BANDIT_BIOMES);
        ModEntities.registerFactionlessWithSpawnEgg(SWORDSMAN_TRAINER, "Dojo Sensei");
        ModEntities.registerFactionlessWithSpawnEgg(SNIPER_TRAINER, "Bow Master");
        ModEntities.registerFactionlessWithSpawnEgg(ART_OF_WEATHER_TRAINER, "Weather Wizard");
        ModEntities.registerFactionlessWithSpawnEgg(DOCTOR_TRAINER, "Doctor");
        ModEntities.registerFactionlessWithSpawnEgg(BRAWLER_TRAINER, "Brawler");
        ModEntities.registerFactionlessWithSpawnEgg(BLACK_LEG_TRAINER, "Black Leg Trainer");
        ModEntities.registerFactionlessWithSpawnEgg(SKYPIEAN_CIVILIAN, "Skypiean Civilian");
        ModEntities.registerFactionlessWithSpawnEgg(SKYPIEAN_TRADER, "Skypiean Trader");
        ModEntities.registerAnimalWithSpawnEgg(DEN_DEN_MUSHI, "Den Den Mushi");
        ModEntities.registerEntityWorldSpawn(DEN_DEN_MUSHI, 12, 2, 5, GENERIC_ONES);
        ModEntities.registerAnimalWithSpawnEgg(LAPAHN, "Lapahn");
        ModEntities.registerEntityWorldSpawn(LAPAHN, 20, 1, 3, Biome.Category.ICY);
        ModEntities.registerAnimalWithSpawnEgg(KUNG_FU_DUGONG, "Kung Fu Dugong");
        ModEntities.registerEntityWorldSpawn(KUNG_FU_DUGONG, 22, 3, 5, Biome.Category.BEACH, Biome.Category.MUSHROOM, Biome.Category.SWAMP, Biome.Category.RIVER);
        ModEntities.registerAnimalWithSpawnEgg(YAGARA_BULL, "Yagara Bull");
        ModEntities.registerEntityWorldSpawn(YAGARA_BULL, 5, 1, 3, Biome.Category.RIVER, Biome.Category.OCEAN);
        ModEntities.registerAnimalWithSpawnEgg(HUMANDRILL, "Humandrill");
        ModEntities.registerEntityWorldSpawn(HUMANDRILL, 20, 1, 3, Biome.Category.FOREST, Biome.Category.SWAMP, Biome.Category.PLAINS, Biome.Category.JUNGLE);
        ModEntities.registerAnimalWithSpawnEgg(FIGHTING_FISH, "Fighting Fish");
        ModEntities.registerEntityWorldSpawn(FIGHTING_FISH, 1, 1, 3, Biomes.field_76771_b, Biomes.field_150575_M, Biomes.field_203615_U, Biomes.field_203618_X, Biomes.field_203614_T, Biomes.field_203617_W);
        WyRegistry.registerEntityType(DOPPELMAN, "Doppelman");
        WyRegistry.registerEntityType(WAX_CLONE, "Wax Clone");
        WyRegistry.registerEntityType(BLACK_KNIGHT, "Black Knight");
        WyRegistry.registerEntityType(WANTED_POSTER_PACKAGE, "Wanted Poster Package");
        WyRegistry.registerEntityType(VIVRE_CARD, "Vivre Card");
        WyRegistry.registerEntityType(PHYSICAL_BODY, "Physical Body");
        WyRegistry.registerEntityType(SNIPER_TARGET, "Sniper Target");
        WyRegistry.registerEntityType(MIRAGE_CLONE, "Mirage Clone");
        WyRegistry.registerEntityType(BOMB, "Bomb");
        WyRegistry.registerEntityType(SPIKE, "Spike");
        WyRegistry.registerEntityType(DEVIL_FRUIT_ITEM, "Devil Fruit Item");
    }
}

