/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items.armors;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.models.armors.ColaBackpackModel;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class ColaBackpackItem
extends ArmorItem {
    public ColaBackpackItem() {
        super((IArmorMaterial)ModArmors.COLA_BACKPACK_MATERIAL, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(ModCreativeTabs.EQUIPMENT));
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        ColaBackpackModel armorModel = new ColaBackpackModel();
        return (A)((Object)armorModel);
    }

    @Nullable
    public String getArmorTexture(ItemStack itemStack, Entity entity, EquipmentSlotType slot, String type) {
        return String.format("%s:textures/models/armor/cola_backpack.png", "mineminenomi");
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (entity.func_92059_d().func_77942_o() && entity.func_92059_d().func_77978_p().func_74767_n("HasBackpackEquipped")) {
            entity.func_92059_d().func_77978_p().func_74757_a("HasBackpackEquipped", false);
        }
        return false;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof PlayerEntity && !world.field_72995_K) {
            PlayerEntity player = (PlayerEntity)entity;
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
            if (props.isCyborg()) {
                if (!itemStack.func_77942_o()) {
                    itemStack.func_77982_d(new CompoundNBT());
                }
                if (chest.func_77973_b() == this) {
                    if (!itemStack.func_77978_p().func_74767_n("HasBackpackEquipped")) {
                        itemStack.func_77978_p().func_74757_a("HasBackpackEquipped", true);
                        props.setMaxCola(props.getMaxCola() + 400);
                    }
                    if (player.field_70173_aa % 40 == 0) {
                        int colaSlot = this.getColaSlot(player);
                        int ultraColaSlot = this.getUltraColaSlot(player);
                        if (colaSlot != -1 && props.getMaxCola() > props.getCola()) {
                            if (props.getCola() + 15 <= props.getMaxCola()) {
                                props.alterCola(15);
                            } else {
                                props.setCola(props.getMaxCola());
                            }
                            player.field_71071_by.func_70298_a(colaSlot, 1);
                            WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), (PlayerEntity)((ServerPlayerEntity)player));
                        } else if (ultraColaSlot != -1 && props.getMaxCola() > props.getCola()) {
                            if (props.getCola() + 40 <= props.getMaxCola()) {
                                props.alterCola(40);
                            } else {
                                props.setCola(props.getMaxCola());
                            }
                            player.func_195064_c(new EffectInstance(Effects.field_76428_l, 60, 0, false, false));
                            player.func_195064_c(new EffectInstance(Effects.field_76420_g, 60, 0, false, false));
                            player.func_195064_c(new EffectInstance(Effects.field_76424_c, 60, 0, false, false));
                            player.field_71071_by.func_70298_a(ultraColaSlot, 1);
                            WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), (PlayerEntity)((ServerPlayerEntity)player));
                        }
                    }
                } else if (itemStack.func_77978_p().func_74767_n("HasBackpackEquipped")) {
                    itemStack.func_77978_p().func_74757_a("HasBackpackEquipped", false);
                    props.setMaxCola(props.getMaxCola() - 400);
                    if (props.getCola() >= props.getMaxCola()) {
                        props.setCola(props.getMaxCola());
                    }
                    WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), (PlayerEntity)((ServerPlayerEntity)player));
                }
            }
        }
    }

    public int getColaSlot(PlayerEntity player) {
        if (!player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.COLA))) {
            return -1;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.COLA) continue;
            return i;
        }
        return -1;
    }

    public int getUltraColaSlot(PlayerEntity player) {
        if (!player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.ULTRA_COLA))) {
            return -1;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.ULTRA_COLA) continue;
            return i;
        }
        return -1;
    }
}

