/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items.weapons;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import xyz.pixelatedw.mineminenomi.abilities.bomu.BreezeBreathBombAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.bomu.BreezeBreathBombProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class GunItem
extends Item {
    private int maxGunpowder = 3;
    private int bulletSpeed = 2;
    private int bulletAccuracy = 2;
    private int shotCooldown = 10;
    private int reloadCooldown = 20;
    private float damageMultiplier = 1.0f;
    public Predicate<ItemStack> bulletCheck;
    public static final Predicate<ItemStack> GUN_AMMO = itemStack -> itemStack.func_77973_b() == ModItems.BULLET || itemStack.func_77973_b() == ModItems.KAIROSEKI_BULLET;
    public static final Predicate<ItemStack> BAZOOKA_AMMO = itemStack -> itemStack.func_77973_b() == ModItems.CANNON_BALL;

    public GunItem(int maxDamage) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.WEAPONS).func_200917_a(1).func_200915_b(maxDamage));
        this.bulletCheck = GUN_AMMO;
    }

    public GunItem(int maxDamage, Predicate<ItemStack> bulletPredicate) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.WEAPONS).func_200917_a(1).func_200915_b(maxDamage));
        this.bulletCheck = bulletPredicate;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        boolean hasGunPowder;
        boolean flag;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        BreezeBreathBombAbility ability = abilityProps.getEquippedAbility(BreezeBreathBombAbility.INSTANCE);
        boolean hasAbility = ability != null && ability.isContinuous();
        boolean hasBullets = this.findBulletStack(player) != null;
        Item bulletType = this.findBulletStack(player) != null ? this.findBulletStack(player).func_77973_b() : null;
        ItemStack heldItemStack = player.func_184586_b(hand);
        boolean bl = flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)heldItemStack) > 0;
        if (hasAbility) {
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldItemStack);
        }
        if (flag) {
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldItemStack);
        }
        if (!hasBullets || bulletType == null) {
            return new ActionResult(ActionResultType.FAIL, (Object)heldItemStack);
        }
        boolean bl2 = hasGunPowder = this.getLoadedGunPowder(heldItemStack) > 0;
        if (!hasGunPowder) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_77973_b() != Items.field_151016_H) continue;
                int count = this.maxGunpowder;
                if (stack.func_190916_E() < count) {
                    count = stack.func_190916_E();
                }
                this.setLoadedGunPowder(heldItemStack, count);
                player.field_71071_by.func_70298_a(i, count);
                hasGunPowder = true;
                player.func_184811_cZ().func_185145_a((Item)this, this.reloadCooldown);
                break;
            }
        }
        if (!hasGunPowder) {
            return new ActionResult(ActionResultType.FAIL, (Object)heldItemStack);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)heldItemStack);
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity entityLiving, int timeLeft) {
        boolean hasAbility;
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        Item bulletType = this.findBulletStack(player) != null ? this.findBulletStack(player).func_77973_b() : null;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        BreezeBreathBombAbility ability = abilityProps.getEquippedAbility(BreezeBreathBombAbility.INSTANCE);
        boolean bl = hasAbility = ability != null && ability.isContinuous();
        if (!player.field_70170_p.field_72995_K && hasAbility) {
            ability.stopContinuity(player);
            BreezeBreathBombProjectile proj = new BreezeBreathBombProjectile(player.field_70170_p, (LivingEntity)player);
            player.field_70170_p.func_217376_c((Entity)proj);
            proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.0f, 1.0f);
            return;
        }
        int powder = this.getLoadedGunPowder(itemStack);
        if (!world.field_72995_K) {
            int k;
            boolean flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemStack) > 0;
            int i = this.func_77626_a(itemStack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)itemStack, (World)world, (PlayerEntity)player, (int)i, (!itemStack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            AbilityProjectileEntity proj = new NormalBulletProjectile(player.field_70170_p, (LivingEntity)player);
            if (bulletType == ModItems.BULLET) {
                proj = new NormalBulletProjectile(player.field_70170_p, (LivingEntity)player);
            } else if (bulletType == ModItems.KAIROSEKI_BULLET) {
                proj = new KairosekiBulletProjectile(player.field_70170_p, (LivingEntity)player);
            } else if (bulletType == ModItems.CANNON_BALL) {
                proj = new CannonBallProjectile(player.field_70170_p, (LivingEntity)player);
            }
            int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)itemStack);
            if (j > 0) {
                proj.setDamage((float)((double)proj.getDamage() + (double)j * 0.5 + 0.5));
            }
            if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)itemStack)) > 0) {
                proj.setKnockbackStrength(k);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)itemStack) > 0) {
                proj.func_70015_d(3);
            }
            proj.setDamage(Math.round(proj.getDamage() * this.damageMultiplier));
            player.field_70170_p.func_217376_c((Entity)proj);
            proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, this.bulletSpeed, this.bulletAccuracy);
            itemStack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(player.func_184600_cs()));
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
        player.func_184811_cZ().func_185145_a((Item)this, this.shotCooldown);
        this.setLoadedGunPowder(itemStack, Math.max(0, --powder));
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!this.bulletCheck.test(stack)) continue;
            player.field_71071_by.func_70298_a(i, 1);
            break;
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new CompoundNBT());
            itemStack.func_77978_p().func_74768_a("gunPowder", 0);
        }
    }

    public void setLoadedGunPowder(ItemStack itemStack, int powder) {
        itemStack.func_77978_p().func_74768_a("gunPowder", powder);
    }

    public int getLoadedGunPowder(ItemStack itemStack) {
        return itemStack.func_77978_p().func_74762_e("gunPowder");
    }

    public ItemStack findBulletStack(PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!this.bulletCheck.test(stack)) continue;
            return stack;
        }
        return null;
    }

    public GunItem setGunpowderLimit(int limit) {
        this.maxGunpowder = limit;
        return this;
    }

    public GunItem setDamageMultiplier(float damage) {
        this.damageMultiplier = damage;
        return this;
    }

    public GunItem setShotCooldown(int cd) {
        this.shotCooldown = cd;
        return this;
    }

    public GunItem setReloadCooldown(int cd) {
        this.reloadCooldown = cd;
        return this;
    }

    public GunItem setBulletAccuracy(int acc) {
        this.bulletAccuracy = acc;
        return this;
    }

    public GunItem setBulletSpeed(int speed) {
        this.bulletSpeed = speed;
        return this;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag par4) {
        if (itemStack.func_77942_o()) {
            list.add((ITextComponent)new StringTextComponent("Gun Powder : " + itemStack.func_77978_p().func_74762_e("gunPowder")));
        }
    }
}

