/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.events.DorikiEvent;
import xyz.pixelatedw.mineminenomi.api.events.SetPlayerDetailsEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.CharacterCreatorItem;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

public class CFinishCCPacket {
    private int factionId;
    private int raceId;
    private int styleId;
    private static final String[] FACTIONS = new String[]{"Random", "pirate", "marine", "bounty_hunter", "revolutionary"};
    private static final String[] RACES = new String[]{"Random", "human", "fishman", "cyborg", "mink"};
    private static final String[] STYLES = new String[]{"Random", "swordsman", "sniper", "doctor", "art_of_weather", "brawler", "black_leg"};
    private static final String[] MINK_SUB_RACES = new String[]{"mink_bunny", "mink_dog", "mink_lion"};

    public CFinishCCPacket() {
    }

    public CFinishCCPacket(int factionId, int raceId, int styleId) {
        this.factionId = factionId;
        this.raceId = raceId;
        this.styleId = styleId;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.factionId);
        buffer.writeInt(this.raceId);
        buffer.writeInt(this.styleId);
    }

    public static CFinishCCPacket decode(PacketBuffer buffer) {
        CFinishCCPacket msg = new CFinishCCPacket();
        msg.factionId = buffer.readInt();
        msg.raceId = buffer.readInt();
        msg.styleId = buffer.readInt();
        return msg;
    }

    public static void handle(CFinishCCPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                boolean hasEmptyStats;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
                IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
                Random rand = player.func_70681_au();
                boolean hasCharBook = !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b().equals(ModItems.CHARACTER_CREATOR);
                boolean bl = hasEmptyStats = WyHelper.isNullOrEmpty(entityProps.getFaction()) || WyHelper.isNullOrEmpty(entityProps.getRace()) || WyHelper.isNullOrEmpty(entityProps.getFightingStyle());
                if (!hasCharBook && !hasEmptyStats) {
                    return;
                }
                message.factionId %= FACTIONS.length;
                message.raceId %= RACES.length;
                message.styleId %= STYLES.length;
                String faction = message.factionId == 0 ? FACTIONS[1 + rand.nextInt(FACTIONS.length - 1)] : FACTIONS[message.factionId];
                entityProps.setFaction(faction);
                String race = message.raceId == 0 || CommonConfig.INSTANCE.getRaceRandomizer() ? RACES[1 + rand.nextInt(RACES.length - 1)] : RACES[message.raceId];
                entityProps.setRace(race);
                if (entityProps.isMink()) {
                    String subRace = MINK_SUB_RACES[rand.nextInt(MINK_SUB_RACES.length)];
                    entityProps.setSubRace(subRace);
                }
                String style = message.styleId == 0 ? STYLES[1 + rand.nextInt(STYLES.length - 1)] : STYLES[message.styleId];
                entityProps.setFightingStyle(style);
                DorikiEvent e = new DorikiEvent((PlayerEntity)player, entityProps.getDoriki());
                MinecraftForge.EVENT_BUS.post((Event)e);
                AbilityHelper.validateRacialMoves((PlayerEntity)player);
                if (entityProps.isCyborg()) {
                    if (entityProps.getMaxCola() < 100) {
                        entityProps.setMaxCola(100);
                    }
                    entityProps.setCola(entityProps.getMaxCola());
                }
                for (ItemStack is : player.field_71071_by.field_70462_a) {
                    if (is == null || !(is.func_77973_b() instanceof CharacterCreatorItem)) continue;
                    player.field_71071_by.func_184437_d(is);
                }
                SetPlayerDetailsEvent event = new SetPlayerDetailsEvent((PlayerEntity)player);
                MinecraftForge.EVENT_BUS.post((Event)event);
                WyNetwork.sendToAllTrackingAndSelf(new SSyncEntityStatsPacket(player.func_145782_y(), entityProps), (LivingEntity)player);
                WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), abilityProps), (PlayerEntity)player);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

