/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class CToggleCombatModePacket {
    private boolean combatMode = false;

    public CToggleCombatModePacket() {
    }

    public CToggleCombatModePacket(boolean combatMode) {
        this.combatMode = combatMode;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.combatMode);
    }

    public static CToggleCombatModePacket decode(PacketBuffer buffer) {
        CToggleCombatModePacket msg = new CToggleCombatModePacket();
        msg.combatMode = buffer.readBoolean();
        return msg;
    }

    public static void handle(CToggleCombatModePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
                props.setCombatMode(message.combatMode);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

