/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.quest;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncQuestDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class CStartObjectiveEventPacket {
    private int questId;
    private int objId;

    public CStartObjectiveEventPacket() {
    }

    public CStartObjectiveEventPacket(int questId, int objId) {
        this.questId = questId;
        this.objId = objId;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.questId);
        buffer.writeInt(this.objId);
    }

    public static CStartObjectiveEventPacket decode(PacketBuffer buffer) {
        CStartObjectiveEventPacket msg = new CStartObjectiveEventPacket();
        msg.questId = buffer.readInt();
        msg.objId = buffer.readInt();
        return msg;
    }

    public static void handle(CStartObjectiveEventPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                Objective obj;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IQuestData props = QuestDataCapability.get((PlayerEntity)player);
                Object current = props.getInProgressQuest(message.questId);
                if (current != null && (obj = ((Quest)((Object)((Object)current))).getObjectives().get(message.objId)) != null) {
                    if (obj.hasStartedEvent()) {
                        obj.triggerRestartEvent((PlayerEntity)player);
                    } else {
                        obj.triggerStartEvent((PlayerEntity)player);
                    }
                    WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

