/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.quest;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.entities.TrainerEntity;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncQuestDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class CUpdateQuestStatePacket {
    private INBT data;
    private String questId;
    private byte state;

    public CUpdateQuestStatePacket() {
    }

    public CUpdateQuestStatePacket(Quest quest, byte state) {
        this.questId = quest.getId();
        this.state = state;
    }

    @Deprecated
    public CUpdateQuestStatePacket(IQuestData props) {
        this.data = new CompoundNBT();
        this.data = QuestDataCapability.INSTANCE.getStorage().writeNBT(QuestDataCapability.INSTANCE, (Object)props, null);
    }

    public void encode(PacketBuffer buffer) {
        int len = this.questId.length();
        buffer.writeInt(len);
        buffer.func_211400_a(this.questId, len);
        buffer.writeByte((int)this.state);
    }

    public static CUpdateQuestStatePacket decode(PacketBuffer buffer) {
        CUpdateQuestStatePacket msg = new CUpdateQuestStatePacket();
        int len = buffer.readInt();
        msg.questId = buffer.func_150789_c(len);
        msg.state = buffer.readByte();
        return msg;
    }

    public static void handle(CUpdateQuestStatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                if (WyHelper.isNullOrEmpty(message.questId)) {
                    return;
                }
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Optional trainer = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 10.0, TrainerEntity.class).stream().findFirst();
                if (!trainer.isPresent()) {
                    return;
                }
                IQuestData props = QuestDataCapability.get((PlayerEntity)player);
                Quest quest = (Quest)GameRegistry.findRegistry(Quest.class).getValue(new ResourceLocation(APIConfig.projectId, message.questId));
                if (quest == null || quest.isLocked(props)) {
                    return;
                }
                if (!Arrays.stream(((TrainerEntity)trainer.get()).getAvailableQuests((PlayerEntity)player)).anyMatch(q -> q.equals((Object)quest))) {
                    return;
                }
                if (message.state == 0 && !props.hasInProgressQuest(quest)) {
                    props.addInProgressQuest(quest);
                } else if (message.state == 1 && props.hasInProgressQuest(quest) && props.getInProgressQuest(quest).isComplete()) {
                    props.addFinishedQuest(quest);
                    props.removeInProgressQuest(quest);
                }
                WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

