/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.haki;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HaoshokuHakiParticleEffect
extends ParticleEffect {
    private int level;

    public HaoshokuHakiParticleEffect(int level) {
        this.level = level;
    }

    @Override
    public void spawn(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        double phi = 0.0;
        double radius = 1.0;
        Random rand = world.field_73012_v;
        int i = 0;
        while (phi < 1.0) {
            phi += 1.5707963267948966;
            for (double theta = 0.0; theta <= Math.PI * 2; theta += 0.04908738521234052) {
                double x = phi * Math.cos(theta);
                double y = WyHelper.randomDouble() / 2.0;
                double z = phi * Math.sin(theta);
                motionX = x * 1.2;
                motionY = 0.2 + rand.nextDouble() / 8.0;
                motionZ = z * 1.2;
                GenericParticleData data = i % 3 == 0 ? new GenericParticleData(ModParticleTypes.GASU2) : new GenericParticleData(ModParticleTypes.MOKU);
                data.setLife(20);
                data.setSize(8.0f);
                data.setMotion(motionX, motionY / 2.0, motionZ);
                data.setColor(0.7f, 0.0f, 0.7f, 0.5f);
                WyHelper.spawnParticles(data, (ServerWorld)world, posX + x, posY - 0.2 + y, posZ + z);
                if (this.level >= 2) {
                    data = i % 3 == 0 ? new GenericParticleData(ModParticleTypes.GASU2) : new GenericParticleData(ModParticleTypes.MOKU);
                    data.setLife(20);
                    data.setSize(7.0f);
                    data.setMotion(motionX, motionY / 1.5, motionZ);
                    data.setColor(0.7f, 0.0f, 0.7f, 0.5f);
                    WyHelper.spawnParticles(data, (ServerWorld)world, posX + x * 1.35, posY + 0.2 + y, posZ + z * 1.35);
                    data = i % 3 == 0 ? new GenericParticleData(ModParticleTypes.GASU2) : new GenericParticleData(ModParticleTypes.MOKU);
                    data.setLife(20);
                    data.setSize(7.0f);
                    data.setMotion(motionX, motionY, motionZ);
                    data.setColor(0.7f, 0.0f, 0.7f, 0.5f);
                    WyHelper.spawnParticles(data, (ServerWorld)world, posX + x * 1.25, posY + 1.2 + y, posZ + z * 1.25);
                    data = i % 3 == 0 ? new GenericParticleData(ModParticleTypes.GASU2) : new GenericParticleData(ModParticleTypes.MOKU);
                    data.setLife(20);
                    data.setSize(8.0f);
                    data.setMotion(motionX, motionY, motionZ);
                    data.setColor(0.7f, 0.0f, 0.7f, 0.5f);
                    WyHelper.spawnParticles(data, (ServerWorld)world, posX + x * 0.85, posY + 2.2 + y, posZ + z * 0.85);
                }
                if (this.level >= 3) {
                    for (int n = 0; n < 12; ++n) {
                        x = radius * Math.cos(theta) * Math.sin(phi) + WyHelper.randomDouble();
                        y = radius * Math.cos(phi) + WyHelper.randomDouble() * 2.0;
                        z = radius * Math.sin(theta) * Math.sin(phi) + WyHelper.randomDouble();
                        data = i % 3 == 0 ? new GenericParticleData(ModParticleTypes.GASU) : new GenericParticleData(ModParticleTypes.YUKI);
                        data.setLife(18);
                        data.setSize(5.0f);
                        data.setMotion(motionX / 1.1, 0.3, motionZ / 1.1);
                        data.setColor(0.7f, 0.0f, 0.7f);
                        WyHelper.spawnParticles(data, (ServerWorld)world, posX + x, posY - 0.5 + y, posZ + z);
                        motionY = Math.abs(y * 1.01);
                        data = i % 3 == 0 ? new GenericParticleData(ModParticleTypes.GASU) : new GenericParticleData(ModParticleTypes.YUKI);
                        data.setLife(18);
                        data.setSize(5.0f);
                        data.setMotion(motionX / 1.1, motionY / 1.5, motionZ / 1.1);
                        data.setColor(0.7f, 0.0f, 0.7f);
                        WyHelper.spawnParticles(data, (ServerWorld)world, posX + x, posY - 0.5 + y, posZ + z);
                    }
                }
                ++i;
            }
        }
    }
}

