/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.objectives;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IKillEntityObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;

public class KillEntityObjective
extends Objective
implements IKillEntityObjective {
    protected ICheckKill killEvent = (player, target, source) -> {
        IAttributeInstance attackAttribute = target.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
        boolean isAggressive = attackAttribute != null && attackAttribute.func_111126_e() > 0.0;
        return isAggressive;
    };

    public KillEntityObjective(String title, int count) {
        this(title, count, (ICheckKill)null);
    }

    public KillEntityObjective(String title, int count, EntityType entityType) {
        this(title, count, (PlayerEntity player, LivingEntity target, DamageSource source) -> target.func_200600_R() == entityType);
    }

    public KillEntityObjective(String title, int count, ICheckKill check) {
        super(title);
        this.setMaxProgress(count);
        if (check != null) {
            this.killEvent = check;
        }
    }

    @Override
    public boolean checkKill(PlayerEntity player, LivingEntity target, DamageSource source) {
        return this.killEvent.test(player, target, source);
    }

    @FunctionalInterface
    public static interface ICheckKill {
        public boolean test(PlayerEntity var1, LivingEntity var2, DamageSource var3);

        default public ICheckKill and(ICheckKill check) {
            return (player, target, source) -> this.test(player, target, source) && check.test(player, target, source);
        }

        default public ICheckKill or(ICheckKill check) {
            return (player, target, source) -> this.test(player, target, source) || check.test(player, target, source);
        }
    }
}

