/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.objectives;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;

public class TimedKillEntityObjective
extends KillEntityObjective {
    private long lastHit = 0L;
    private int seconds = 0;

    public TimedKillEntityObjective(String title, int count, int seconds) {
        super(title, count, (KillEntityObjective.ICheckKill)null);
        this.seconds = seconds * 20;
    }

    public TimedKillEntityObjective(String title, int count, int seconds, KillEntityObjective.ICheckKill check) {
        super(title, count, check);
        this.seconds = seconds * 20;
    }

    @Override
    public boolean checkKill(PlayerEntity player, LivingEntity target, DamageSource source) {
        long hitTime = player.field_70170_p.func_82737_E();
        if (this.lastHit == 0L) {
            this.lastHit = player.field_70170_p.func_82737_E();
        }
        if (hitTime - (long)this.seconds <= this.lastHit) {
            this.lastHit = hitTime;
            return super.checkKill(player, target, source);
        }
        this.setProgress(0.0);
        this.lastHit = 0L;
        return false;
    }

    @Override
    public String getLocalizedTitle() {
        String objectiveKey = new TranslationTextComponent(String.format("quest.objective." + APIConfig.projectId + ".%s", this.getId()), new Object[0]).func_150268_i();
        return new TranslationTextComponent(objectiveKey, new Object[]{(int)this.getMaxProgress(), this.seconds / 20}).func_150254_d();
    }
}

