/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.entities.zoans;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.api.ZoanInfo;
import xyz.pixelatedw.mineminenomi.api.ZoanMorphModel;
import xyz.pixelatedw.mineminenomi.api.events.RenderMorphEvent;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.renderers.layers.AuraLayer;

@OnlyIn(value=Dist.CLIENT)
public class ZoanMorphRenderer<T extends AbstractClientPlayerEntity, M extends ZoanMorphModel>
extends PlayerRenderer {
    protected ZoanInfo info;

    public ZoanMorphRenderer(EntityRendererManager rendererManager, ZoanInfo info) {
        super(rendererManager);
        if (info.getModel() != null) {
            this.field_77045_g = info.getModel();
        }
        this.field_76989_e = info.getShadowSize();
        this.info = info;
        this.func_177094_a(new AuraLayer((IEntityRenderer)this));
        this.removeLayer(BipedArmorLayer.class);
        this.removeLayer(CapeLayer.class);
        this.removeLayer(ElytraLayer.class);
    }

    public void func_225623_a_(AbstractClientPlayerEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        Direction direction;
        boolean shouldSit;
        this.setModelVisibilities(entity);
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderMorphEvent.Pre((PlayerEntity)entity, this, partialTicks, matrixStack, buffer, packedLight))) {
            return;
        }
        matrixStack.func_227860_a_();
        ((PlayerModel)this.field_77045_g).field_217112_c = this.func_77040_d((LivingEntity)entity, partialTicks);
        ((PlayerModel)this.field_77045_g).field_217113_d = shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        ((PlayerModel)this.field_77045_g).field_217114_e = entity.func_70631_g_();
        float headYawOffset = MathHelper.func_219805_h((float)partialTicks, (float)entity.field_70760_ar, (float)entity.field_70761_aq);
        float headYawRotation = MathHelper.func_219805_h((float)partialTicks, (float)entity.field_70758_at, (float)entity.field_70759_as);
        float netHeadYaw = headYawRotation - headYawOffset;
        if (shouldSit && entity.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.func_184187_bx();
            headYawOffset = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            netHeadYaw = headYawRotation - headYawOffset;
            float f3 = MathHelper.func_76142_g((float)netHeadYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            headYawOffset = headYawRotation - f3;
            if (f3 * f3 > 2500.0f) {
                headYawOffset += f3 * 0.2f;
            }
            netHeadYaw = headYawRotation - headYawOffset;
        }
        float headPitch = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70127_C, (float)entity.field_70125_A);
        if (entity.func_213283_Z() == Pose.SLEEPING && (direction = entity.func_213376_dz()) != null) {
            float eyeHeight = entity.func_213307_e(Pose.STANDING) - 0.1f;
            matrixStack.func_227861_a_((double)((float)(-direction.func_82601_c()) * eyeHeight), 0.0, (double)((float)(-direction.func_82599_e()) * eyeHeight));
        }
        float ageInTicks = this.func_77044_a((LivingEntity)entity, partialTicks);
        this.func_225621_a_(entity, matrixStack, ageInTicks, headYawOffset, partialTicks);
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.info.preRenderCallback(entity, matrixStack, partialTicks);
        this.func_225620_a_(entity, matrixStack, partialTicks);
        matrixStack.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && entity.func_70089_S()) {
            limbSwingAmount = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_184618_aE, (float)entity.field_70721_aZ);
            limbSwing = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
            if (entity.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        this.renderModel(entity, matrixStack, packedLight, buffer, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        if (!entity.func_175149_v()) {
            for (LayerRenderer layerrenderer : this.field_177097_h) {
                layerrenderer.func_225628_a_(matrixStack, buffer, packedLight, (Entity)entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }
        matrixStack.func_227865_b_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderMorphEvent.Post((PlayerEntity)entity, this, partialTicks, matrixStack, buffer, packedLight));
        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent((Entity)entity, entity.func_145748_c_().func_150254_d(), (EntityRenderer)this, matrixStack, buffer, packedLight);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.func_177070_b((LivingEntity)entity))) {
            this.func_225629_a_(entity, renderNameplateEvent.getContent(), matrixStack, buffer, packedLight);
        }
    }

    protected void renderModel(AbstractClientPlayerEntity entity, MatrixStack matrixStack, int packedLight, IRenderTypeBuffer buffer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ((PlayerModel)this.field_77045_g).func_212843_a_((LivingEntity)entity, limbSwing, limbSwingAmount, partialTicks);
        ((PlayerModel)this.field_77045_g).func_225597_a_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        boolean flag = this.func_225622_a_((LivingEntity)entity);
        boolean flag1 = !flag && !entity.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        RenderType renderType = ModRenderTypes.getZoanRenderType(this.func_110775_a(entity));
        if (renderType != null && flag) {
            IVertexBuilder ivertexbuilder = buffer.getBuffer(renderType);
            int i = ZoanMorphRenderer.func_229117_c_((LivingEntity)entity, (float)this.func_225625_b_((LivingEntity)entity, partialTicks));
            ((PlayerModel)this.field_77045_g).func_225598_a_(matrixStack, ivertexbuilder, packedLight, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
    }

    private void setModelVisibilities(AbstractClientPlayerEntity clientPlayer) {
        PlayerModel playermodel = (PlayerModel)this.func_217764_d();
        if (clientPlayer.func_175149_v()) {
            playermodel.func_178719_a(false);
            playermodel.field_78116_c.field_78806_j = true;
            playermodel.field_178720_f.field_78806_j = true;
        } else {
            ItemStack itemstack = clientPlayer.func_184614_ca();
            ItemStack itemstack1 = clientPlayer.func_184592_cb();
            playermodel.field_228270_o_ = clientPlayer.func_213453_ef();
            BipedModel.ArmPose bipedmodel$armpose = this.getArmPose(clientPlayer, itemstack, itemstack1, Hand.MAIN_HAND);
            BipedModel.ArmPose bipedmodel$armpose1 = this.getArmPose(clientPlayer, itemstack, itemstack1, Hand.OFF_HAND);
            if (clientPlayer.func_184591_cq() == HandSide.RIGHT) {
                playermodel.field_187076_m = bipedmodel$armpose;
                playermodel.field_187075_l = bipedmodel$armpose1;
            } else {
                playermodel.field_187076_m = bipedmodel$armpose1;
                playermodel.field_187075_l = bipedmodel$armpose;
            }
        }
    }

    protected void removeLayer(Class<? extends LayerRenderer> clz) {
        this.field_177097_h.removeIf(layer -> clz.equals(layer.getClass()));
    }

    private BipedModel.ArmPose getArmPose(AbstractClientPlayerEntity playerIn, ItemStack itemStackMain, ItemStack itemStackOff, Hand handIn) {
        ItemStack itemstack;
        BipedModel.ArmPose bipedmodel$armpose = BipedModel.ArmPose.EMPTY;
        ItemStack itemStack = itemstack = handIn == Hand.MAIN_HAND ? itemStackMain : itemStackOff;
        if (!itemstack.func_190926_b()) {
            bipedmodel$armpose = BipedModel.ArmPose.ITEM;
            if (playerIn.func_184605_cv() > 0) {
                UseAction useaction = itemstack.func_77975_n();
                if (useaction == UseAction.BLOCK) {
                    bipedmodel$armpose = BipedModel.ArmPose.BLOCK;
                } else if (useaction == UseAction.BOW) {
                    bipedmodel$armpose = BipedModel.ArmPose.BOW_AND_ARROW;
                } else if (useaction == UseAction.SPEAR) {
                    bipedmodel$armpose = BipedModel.ArmPose.THROW_SPEAR;
                } else if (useaction == UseAction.CROSSBOW && handIn == playerIn.func_184600_cs()) {
                    bipedmodel$armpose = BipedModel.ArmPose.CROSSBOW_CHARGE;
                }
            } else {
                boolean flag3 = itemStackMain.func_77973_b() == Items.field_222114_py;
                boolean flag = CrossbowItem.func_220012_d((ItemStack)itemStackMain);
                boolean flag1 = itemStackOff.func_77973_b() == Items.field_222114_py;
                boolean flag2 = CrossbowItem.func_220012_d((ItemStack)itemStackOff);
                if (flag3 && flag) {
                    bipedmodel$armpose = BipedModel.ArmPose.CROSSBOW_HOLD;
                }
                if (flag1 && flag2 && itemStackMain.func_77973_b().func_77661_b(itemStackMain) == UseAction.NONE) {
                    bipedmodel$armpose = BipedModel.ArmPose.CROSSBOW_HOLD;
                }
            }
        }
        return bipedmodel$armpose;
    }

    public ResourceLocation func_110775_a(AbstractClientPlayerEntity entity) {
        if (this.info.getTexture() != null) {
            return this.info.getTexture();
        }
        return entity.func_110306_p();
    }

    public static class Factory<T extends PlayerEntity>
    implements IRenderFactory<T> {
        private ZoanInfo info;

        public Factory(ZoanInfo info) {
            this.info = info;
        }

        public EntityRenderer<? super T> createRenderFor(EntityRendererManager manager) {
            ZoanMorphRenderer renderer = new ZoanMorphRenderer(manager, this.info);
            return renderer;
        }
    }
}

