/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.OutlineLayerBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiAuraAbility;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class AuraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    public AuraLayer(IEntityRenderer renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean isActive;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (entity == player) {
            return;
        }
        IEntityStats entityData = EntityStatsCapability.get((LivingEntity)player);
        IAbilityData abilityData = AbilityDataCapability.get((LivingEntity)player);
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        KenbunshokuHakiAuraAbility ability = abilityData.getEquippedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
        boolean bl = isActive = ability != null && ability.isContinuous();
        if (isActive) {
            float dorikiPower = (float)entityData.getDoriki() / 1000.0f;
            float hakiPower = hakiProps.getKenbunshokuHakiExp() / 2.0f;
            float finalPower = (dorikiPower + hakiPower) * 1.06f * (float)(DevilFruitCapability.get((LivingEntity)player).hasDevilFruit(ModAbilities.GORO_GORO_NO_MI) ? 4 : 1);
            if (entity.func_70032_d((Entity)player) > finalPower) {
                return;
            }
            matrixStack.func_227860_a_();
            String color = "#5555FF";
            if (entity instanceof AnimalEntity) {
                color = "#55FF55";
            } else if (entity instanceof MonsterEntity) {
                color = "#FF0000";
            } else if (entity instanceof PlayerEntity) {
                color = "#00FFFF";
            }
            OutlineLayerBuffer outline = Minecraft.func_71410_x().func_228019_au_().func_228490_d_();
            Color rgbColor = WyHelper.hexToRGB(color);
            float red = (float)rgbColor.getRed() / 255.0f;
            float green = (float)rgbColor.getGreen() / 255.0f;
            float blue = (float)rgbColor.getBlue() / 255.0f;
            outline.func_228472_a_((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), 200);
            IVertexBuilder vertex = outline.getBuffer(ModRenderTypes.getAuraRenderType(this.func_229139_a_((Entity)entity)));
            this.func_215332_c().func_225598_a_(matrixStack, vertex, packedLight, OverlayTexture.field_229196_a_, red, green, blue, 0.6f);
            matrixStack.func_227865_b_();
        }
    }
}

