/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.SpecialEffect;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;

@OnlyIn(value=Dist.CLIENT)
public class PotionLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static List<EffectInstance> copyEffects = new ArrayList<EffectInstance>();

    public PotionLayer(IEntityRenderer renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        copyEffects.addAll(entity.func_70651_bq());
        for (EffectInstance effectInstance : copyEffects) {
            if (!(effectInstance.func_188419_a() instanceof SpecialEffect)) continue;
            SpecialEffect effect = (SpecialEffect)effectInstance.func_188419_a();
            if (entity.func_70644_a((Effect)effect) && entity.func_70660_b((Effect)effect).func_76459_b() <= 0) {
                entity.func_195063_d((Effect)effect);
            }
            if (effect.getBlockOverlay() != null) {
                Block blockToRender = effect.getBlockOverlay();
                matrixStack.func_227860_a_();
                float blocksWidth = (float)(Math.ceil(entity.func_213311_cf()) + 1.0);
                float blocksHeight = (float)(Math.ceil(entity.func_213302_cg()) + 1.0);
                matrixStack.func_227861_a_((double)(0.4f - blocksWidth / 2.0f), (double)(1.4f - entity.func_213302_cg() / 2.0f - blocksHeight / 2.0f), (double)(0.4f - blocksWidth / 2.0f));
                int x = 0;
                while ((float)x < blocksWidth) {
                    int y = 0;
                    while ((float)y < blocksHeight) {
                        int z = 0;
                        while ((float)z < blocksWidth) {
                            matrixStack.func_227860_a_();
                            matrixStack.func_227861_a_((double)x, (double)y, (double)z);
                            Minecraft.func_71410_x().func_175599_af().func_229110_a_(new ItemStack((IItemProvider)blockToRender), ItemCameraTransforms.TransformType.HEAD, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
                            matrixStack.func_227865_b_();
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                matrixStack.func_227865_b_();
            }
            if (effect.getOverlayColor() == null || !effect.hasBodyOverlayColor()) continue;
            matrixStack.func_227860_a_();
            IVertexBuilder vertex = buffer.getBuffer(effect.getRenderType());
            if (effect.getResourceLocation(effectInstance.func_76459_b()) != null) {
                vertex = buffer.getBuffer(ModRenderTypes.getAbilityBody(effect.getResourceLocation(effectInstance.func_76459_b())));
            }
            this.func_215332_c().func_225598_a_(matrixStack, vertex, packedLight, 0, effect.getOverlayColor()[0], effect.getOverlayColor()[1], effect.getOverlayColor()[2], effect.getOverlayColor()[3]);
            matrixStack.func_227865_b_();
        }
        copyEffects.clear();
    }
}

