/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SettingsScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ForgeI18n;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.screens.config.ConfigCategoryList;
import xyz.pixelatedw.mineminenomi.screens.config.ConfigPage;
import xyz.pixelatedw.mineminenomi.screens.config.categories.BountyConfigPage;
import xyz.pixelatedw.mineminenomi.screens.config.categories.ChallengesConfigPage;
import xyz.pixelatedw.mineminenomi.screens.config.categories.CrewsConfigPage;
import xyz.pixelatedw.mineminenomi.screens.config.categories.DevilFruitsConfigPage;
import xyz.pixelatedw.mineminenomi.screens.config.categories.GeneralConfigPage;
import xyz.pixelatedw.mineminenomi.screens.config.categories.OresConfigPage;
import xyz.pixelatedw.mineminenomi.screens.config.categories.QuestsConfigPage;
import xyz.pixelatedw.mineminenomi.screens.config.categories.StructuresConfigPage;
import xyz.pixelatedw.mineminenomi.screens.config.categories.SystemConfigPage;
import xyz.pixelatedw.mineminenomi.screens.config.categories.WorldEventsConfigPage;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends SettingsScreen {
    private ConfigPage generalCategory = new GeneralConfigPage();
    private ConfigPage devilFruitsCategory = new DevilFruitsConfigPage();
    private ConfigPage structuresCategory = new StructuresConfigPage();
    private ConfigPage worldEventsCategory = new WorldEventsConfigPage();
    private ConfigPage crewsCategory = new CrewsConfigPage();
    private ConfigPage oresCategory = new OresConfigPage();
    private ConfigPage bountyCategory = new BountyConfigPage();
    private ConfigPage questsCategory = new QuestsConfigPage();
    private ConfigPage challengesCategory = new ChallengesConfigPage();
    private ConfigPage systemCategory = new SystemConfigPage();
    private ConfigPage[] categories = new ConfigPage[]{this.generalCategory, this.devilFruitsCategory, this.structuresCategory, this.worldEventsCategory, this.crewsCategory, this.oresCategory, this.bountyCategory, this.questsCategory, this.challengesCategory, this.systemCategory};
    private int categoryOffset = 0;
    private ConfigPage selectedCategory = this.generalCategory;
    private ConfigCategoryList list;

    public ConfigScreen(Screen parent, GameSettings settings) {
        super(parent, settings, (ITextComponent)new TranslationTextComponent("gui.mineminenomi.config.title", new Object[0]));
    }

    protected void init() {
        this.list = new ConfigCategoryList(this);
        this.buttons.clear();
        this.children.clear();
        int posX = this.width / 2 - 265;
        Button prevButton = new Button(posX + 60, 25, 20, 20, "<", x -> {
            if (this.categoryOffset > 0) {
                --this.categoryOffset;
                this.init();
            }
        });
        int j = 0;
        for (int i = this.categoryOffset; i < this.categories.length && j < 4; ++i) {
            ConfigPage category = this.categories[i];
            if (category == null) continue;
            Button categoryButton = new Button(posX += 90, 25, 80, 20, category.getTitle().func_150254_d() + "...", x -> {
                this.selectedCategory = category;
                this.init();
            });
            if (this.selectedCategory == category) {
                categoryButton.active = false;
            }
            ++j;
        }
        Button nextButton = new Button(posX + 90, 25, 20, 20, ">", x -> {
            if (this.categoryOffset < this.categories.length - 4) {
                ++this.categoryOffset;
                this.init();
            }
        });
        if (this.categoryOffset <= 0) {
            prevButton.active = false;
        }
        if (this.categoryOffset >= this.categories.length - 4) {
            nextButton.active = false;
        }
        this.selectedCategory.init(this.list);
        this.addButton((Widget)new Button(this.width / 2 - 154, this.height - 27, 150, 20, I18n.func_135052_a((String)"gui.mineminenomi.config.open_config", (Object[])new Object[0]), x -> Util.func_110647_a().func_195641_a(new File(CommonConfig.CONFIG_PATH.toString()))));
        this.addButton((Widget)new Button(this.width / 2 + 4, this.height - 27, 150, 20, ForgeI18n.parseMessage((String)"gui.done", (Object[])new Object[0]), x -> {
            this.onClose();
            this.minecraft.func_147108_a(this.field_228182_a_);
        }));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 8, 0xFFFFFF);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(this.width / 2), (double)(this.height / 2 - 20), (double)0.0);
        RenderSystem.scaled((double)2.0, (double)2.0, (double)2.0);
        this.drawCenteredString(this.font, "Under Maintenance", 0, 0, 0xFFFFFF);
        RenderSystem.popMatrix();
        super.render(mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        CommonConfig.save();
    }
}

